/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.event;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.event.Event;
import com.google.android.gms.games.event.EventEntityCreator;
import com.google.android.gms.internal.hk;
import com.google.android.gms.internal.ik;

public final class EventEntity
implements SafeParcelable,
Event {
    public static final EventEntityCreator CREATOR = new EventEntityCreator();
    private final int xM;
    private final String Ni;
    private final String mName;
    private final String Mp;
    private final Uri Mr;
    private final String MC;
    private final PlayerEntity Nj;
    private final long Nk;
    private final String Nl;
    private final boolean Nm;

    public EventEntity(Event event) {
        this.xM = 1;
        this.Ni = event.getEventId();
        this.mName = event.getName();
        this.Mp = event.getDescription();
        this.Mr = event.getIconImageUri();
        this.MC = event.getIconImageUrl();
        this.Nj = (PlayerEntity)event.getPlayer().freeze();
        this.Nk = event.getValue();
        this.Nl = event.getFormattedValue();
        this.Nm = event.isVisible();
    }

    EventEntity(int versionCode, String eventId, String name, String description, Uri iconImageUri, String iconImageUrl, Player player, long value, String formattedValue, boolean isVisible) {
        this.xM = versionCode;
        this.Ni = eventId;
        this.mName = name;
        this.Mp = description;
        this.Mr = iconImageUri;
        this.MC = iconImageUrl;
        this.Nj = new PlayerEntity(player);
        this.Nk = value;
        this.Nl = formattedValue;
        this.Nm = isVisible;
    }

    public int getVersionCode() {
        return this.xM;
    }

    @Override
    public String getEventId() {
        return this.Ni;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        ik.b(this.mName, dataOut);
    }

    @Override
    public String getDescription() {
        return this.Mp;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        ik.b(this.Mp, dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.Mr;
    }

    @Override
    public String getIconImageUrl() {
        return this.MC;
    }

    @Override
    public Player getPlayer() {
        return this.Nj;
    }

    @Override
    public long getValue() {
        return this.Nk;
    }

    @Override
    public String getFormattedValue() {
        return this.Nl;
    }

    @Override
    public void getFormattedValue(CharArrayBuffer dataOut) {
        ik.b(this.Nl, dataOut);
    }

    @Override
    public boolean isVisible() {
        return this.Nm;
    }

    @Override
    public Event freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return EventEntity.a(this);
    }

    static int a(Event event) {
        return hk.hashCode(event.getEventId(), event.getName(), event.getDescription(), event.getIconImageUri(), event.getIconImageUrl(), event.getPlayer(), event.getValue(), event.getFormattedValue(), event.isVisible());
    }

    public boolean equals(Object obj) {
        return EventEntity.a(this, obj);
    }

    static boolean a(Event event, Object object) {
        if (!(object instanceof Event)) {
            return false;
        }
        if (event == object) {
            return true;
        }
        Event event2 = (Event)object;
        return hk.equal(event2.getEventId(), event.getEventId()) && hk.equal(event2.getName(), event.getName()) && hk.equal(event2.getDescription(), event.getDescription()) && hk.equal(event2.getIconImageUri(), event.getIconImageUri()) && hk.equal(event2.getIconImageUrl(), event.getIconImageUrl()) && hk.equal(event2.getPlayer(), event.getPlayer()) && hk.equal(event2.getValue(), event.getValue()) && hk.equal(event2.getFormattedValue(), event.getFormattedValue()) && hk.equal(event2.isVisible(), event.isVisible());
    }

    public String toString() {
        return EventEntity.b(this);
    }

    static String b(Event event) {
        return hk.e(event).a("Id", event.getEventId()).a("Name", event.getName()).a("Description", event.getDescription()).a("IconImageUri", event.getIconImageUri()).a("IconImageUrl", event.getIconImageUrl()).a("Player", event.getPlayer()).a("Value", event.getValue()).a("FormattedValue", event.getFormattedValue()).a("isVisible", event.isVisible()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        EventEntityCreator.a(this, out, flags);
    }
}

