/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.common.api.b;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.a;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.AbstractGamesCallbacks;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.internal.IGamesCallbacks;
import com.google.android.gms.games.internal.IGamesService;
import com.google.android.gms.games.internal.LibjingleNativeSocket;
import com.google.android.gms.games.internal.PopupManager;
import com.google.android.gms.games.internal.RealTimeSocketImpl;
import com.google.android.gms.games.internal.constants.RequestType;
import com.google.android.gms.games.internal.events.EventIncrementCache;
import com.google.android.gms.games.internal.events.EventIncrementManager;
import com.google.android.gms.games.internal.experience.ExperienceEventBuffer;
import com.google.android.gms.games.internal.game.Acls;
import com.google.android.gms.games.internal.game.ExtendedGameBuffer;
import com.google.android.gms.games.internal.game.GameInstanceBuffer;
import com.google.android.gms.games.internal.request.RequestUpdateOutcomes;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.ParticipantUtils;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.RealTimeSocket;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomBuffer;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.internal.gx;
import com.google.android.gms.internal.hb;
import com.google.android.gms.internal.hi;
import com.google.android.gms.internal.hm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class GamesClientImpl
extends hb<IGamesService>
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    EventIncrementManager Np = new EventIncrementManager(){

        @Override
        public EventIncrementCache hx() {
            return new GameClientEventIncrementCache();
        }
    };
    private final String Nq;
    private final String yQ;
    private final Map<String, RealTimeSocket> Nr;
    private PlayerEntity Ns;
    private GameEntity Nt;
    private final PopupManager Nu;
    private boolean Nv = false;
    private boolean Nw = false;
    private int Nx;
    private final Binder Ny;
    private final long Nz;
    private final boolean NA;
    private final int NB;
    private final boolean NC;
    private final String ND;

    public GamesClientImpl(Context context, Looper looper, String gamePackageName, String accountName, GoogleApiClient.ConnectionCallbacks connectedListener, GoogleApiClient.OnConnectionFailedListener connectionFailedListener, String[] scopes, int gravity, View gamesContentView, boolean isHeadless, boolean showConnectingPopup, int connectingPopupGravity, boolean retryingSignIn, int sdkVariant, String forceResolveAccountKey) {
        super(context, looper, connectedListener, connectionFailedListener, scopes);
        this.Nq = gamePackageName;
        this.yQ = hm.f(accountName);
        this.Ny = new Binder();
        this.Nr = new HashMap<String, RealTimeSocket>();
        this.Nu = PopupManager.a(this, gravity);
        this.f(gamesContentView);
        this.Nw = showConnectingPopup;
        this.Nx = connectingPopupGravity;
        this.Nz = this.hashCode();
        this.NA = isHeadless;
        this.NC = retryingSignIn;
        this.NB = sdkVariant;
        this.ND = forceResolveAccountKey;
        this.registerConnectionCallbacks(this);
        this.registerConnectionFailedListener(this);
    }

    @Override
    public void onConnected(Bundle connectionHint) {
        if (this.Nv) {
            this.Nu.hL();
            this.Nv = false;
        }
    }

    @Override
    public void onConnectionSuspended(int cause) {
    }

    @Override
    public void onConnectionFailed(ConnectionResult result) {
        this.Nv = false;
    }

    public void cg(int n2) {
        this.Nu.setGravity(n2);
    }

    public void f(View view) {
        this.Nu.g(view);
    }

    @Override
    protected void b(String ... stringArray) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            if (string2.equals("https://www.googleapis.com/auth/games")) {
                bl2 = true;
                continue;
            }
            if (!string2.equals("https://www.googleapis.com/auth/games.firstparty")) continue;
            bl3 = true;
        }
        if (bl3) {
            hm.a(!bl2, "Cannot have both %s and %s!", "https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty");
        } else {
            hm.a(bl2, "Games APIs requires %s to function.", "https://www.googleapis.com/auth/games");
        }
    }

    @Override
    public void connect() {
        this.gY();
        super.connect();
    }

    @Override
    public void disconnect() {
        this.Nv = false;
        if (this.isConnected()) {
            try {
                IGamesService iGamesService = (IGamesService)this.ft();
                iGamesService.hw();
                this.Np.flush();
                iGamesService.q(this.Nz);
            }
            catch (RemoteException remoteException) {
                GamesLog.j("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        this.hv();
        super.disconnect();
    }

    @Override
    protected String bu() {
        return "com.google.android.gms.games.service.START";
    }

    @Override
    protected String bv() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected IGamesService ah(IBinder iBinder) {
        return IGamesService.Stub.aj(iBinder);
    }

    @Override
    public Bundle ef() {
        try {
            Bundle bundle = ((IGamesService)this.ft()).ef();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            return null;
        }
    }

    private void gY() {
        this.Ns = null;
    }

    @Override
    protected void a(hi hi2, hb.e e2) throws RemoteException {
        String string2 = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = new Bundle();
        bundle.putBoolean("com.google.android.gms.games.key.isHeadless", this.NA);
        bundle.putBoolean("com.google.android.gms.games.key.showConnectingPopup", this.Nw);
        bundle.putInt("com.google.android.gms.games.key.connectingPopupGravity", this.Nx);
        bundle.putBoolean("com.google.android.gms.games.key.retryingSignIn", this.NC);
        bundle.putInt("com.google.android.gms.games.key.sdkVariant", this.NB);
        bundle.putString("com.google.android.gms.games.key.forceResolveAccountKey", this.ND);
        hi2.a(e2, 5089000, this.getContext().getPackageName(), this.yQ, this.fs(), this.Nq, this.Nu.hN(), string2, bundle);
    }

    public String gZ() {
        try {
            return ((IGamesService)this.ft()).gZ();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            return null;
        }
    }

    public String ha() {
        try {
            return ((IGamesService)this.ft()).ha();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player hb() {
        this.cn();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.Ns == null) {
                try (PlayerBuffer playerBuffer = new PlayerBuffer(((IGamesService)this.ft()).hy());){
                    if (playerBuffer.getCount() > 0) {
                        this.Ns = (PlayerEntity)playerBuffer.get(0).freeze();
                    }
                }
                catch (RemoteException remoteException) {
                    GamesLog.j("GamesClientImpl", "service died");
                }
            }
        }
        return this.Ns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Game hc() {
        this.cn();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.Nt == null) {
                try (GameBuffer gameBuffer = new GameBuffer(((IGamesService)this.ft()).hA());){
                    if (gameBuffer.getCount() > 0) {
                        this.Nt = (GameEntity)gameBuffer.get(0).freeze();
                    }
                }
                catch (RemoteException remoteException) {
                    GamesLog.j("GamesClientImpl", "service died");
                }
            }
        }
        return this.Nt;
    }

    public void a(a.d<Players.LoadPlayersResult> d2, String string2) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Players.LoadPlayersResult> d2, String[] stringArray) {
        try {
            ((IGamesService)this.ft()).c((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Players.LoadPlayersResult> d2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Players.LoadPlayersResult> d2, String string2, int n2, boolean bl2, boolean bl3) {
        if (!string2.equals("played_with")) {
            throw new IllegalArgumentException("Invalid player collection: " + string2);
        }
        try {
            ((IGamesService)this.ft()).d(new PlayersLoadedBinderCallback(d2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Players.LoadPlayersResult> d2, String string2, String string3, int n2, boolean bl2, boolean bl3) {
        if (!string2.equals("played_with") && !string2.equals("circled")) {
            throw new IllegalArgumentException("Invalid player collection: " + string2);
        }
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), string2, string3, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Players.LoadPlayersResult> d2, boolean bl2) {
        try {
            ((IGamesService)this.ft()).c((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public Intent hd() {
        Intent intent;
        try {
            intent = ((IGamesService)this.ft()).hd();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent aR(String string2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.ft()).aR(string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void b(a.d<Leaderboards.LeaderboardMetadataResult> d2, boolean bl2) {
        try {
            ((IGamesService)this.ft()).b((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(d2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Leaderboards.LeaderboardMetadataResult> d2, String string2, boolean bl2) {
        try {
            ((IGamesService)this.ft()).c((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(d2), string2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Leaderboards.LoadPlayerScoreResult> d2, String string2, String string3, int n2, int n3) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new PlayerLeaderboardScoreLoadedBinderCallback(d2), string2, string3, n2, n3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Leaderboards.LoadScoresResult> d2, String string2, int n2, int n3, int n4, boolean bl2) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(d2), string2, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Leaderboards.LoadScoresResult> d2, String string2, int n2, int n3, int n4, boolean bl2) {
        try {
            ((IGamesService)this.ft()).b((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(d2), string2, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Leaderboards.LoadScoresResult> d2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n2, int n3) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(d2), leaderboardScoreBuffer.iA().iB(), n2, n3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Leaderboards.SubmitScoreResult> d2, String string2, long l2, String string3) {
        try {
            SubmitScoreBinderCallbacks submitScoreBinderCallbacks = d2 == null ? null : new SubmitScoreBinderCallbacks(d2);
            ((IGamesService)this.ft()).a((IGamesCallbacks)submitScoreBinderCallbacks, string2, l2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public Intent he() {
        Intent intent;
        try {
            intent = ((IGamesService)this.ft()).he();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void c(a.d<Achievements.LoadAchievementsResult> d2, boolean bl2) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new AchievementsLoadedBinderCallback(d2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Achievements.UpdateAchievementResult> d2, String string2) {
        try {
            AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = d2 == null ? null : new AchievementUpdatedBinderCallback(d2);
            ((IGamesService)this.ft()).a((IGamesCallbacks)achievementUpdatedBinderCallback, string2, this.Nu.hN(), this.Nu.hM());
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void c(a.d<Achievements.UpdateAchievementResult> d2, String string2) {
        try {
            AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = d2 == null ? null : new AchievementUpdatedBinderCallback(d2);
            ((IGamesService)this.ft()).b((IGamesCallbacks)achievementUpdatedBinderCallback, string2, this.Nu.hN(), this.Nu.hM());
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Achievements.UpdateAchievementResult> d2, String string2, int n2) {
        try {
            AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = d2 == null ? null : new AchievementUpdatedBinderCallback(d2);
            ((IGamesService)this.ft()).a((IGamesCallbacks)achievementUpdatedBinderCallback, string2, n2, this.Nu.hN(), this.Nu.hM());
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Achievements.UpdateAchievementResult> d2, String string2, int n2) {
        try {
            AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = d2 == null ? null : new AchievementUpdatedBinderCallback(d2);
            ((IGamesService)this.ft()).b((IGamesCallbacks)achievementUpdatedBinderCallback, string2, n2, this.Nu.hN(), this.Nu.hM());
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void d(a.d<Events.LoadEventsResult> d2, boolean bl2) {
        try {
            this.Np.flush();
            ((IGamesService)this.ft()).f((IGamesCallbacks)new EventsLoadedBinderCallback(d2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Events.LoadEventsResult> d2, boolean bl2, String ... stringArray) {
        try {
            this.Np.flush();
            ((IGamesService)this.ft()).a((IGamesCallbacks)new EventsLoadedBinderCallback(d2), bl2, stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void l(String string2, int n2) {
        this.Np.l(string2, n2);
    }

    public Intent hf() {
        Intent intent;
        try {
            intent = ((IGamesService)this.ft()).hf();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent hg() {
        Intent intent;
        try {
            intent = ((IGamesService)this.ft()).hg();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void a(OnInvitationReceivedListener onInvitationReceivedListener) {
        try {
            InvitationReceivedBinderCallback invitationReceivedBinderCallback = new InvitationReceivedBinderCallback(onInvitationReceivedListener);
            ((IGamesService)this.ft()).a((IGamesCallbacks)invitationReceivedBinderCallback, this.Nz);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void hh() {
        try {
            ((IGamesService)this.ft()).r(this.Nz);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
        try {
            MatchUpdateReceivedBinderCallback matchUpdateReceivedBinderCallback = new MatchUpdateReceivedBinderCallback(onTurnBasedMatchUpdateReceivedListener);
            ((IGamesService)this.ft()).b((IGamesCallbacks)matchUpdateReceivedBinderCallback, this.Nz);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void hi() {
        try {
            ((IGamesService)this.ft()).s(this.Nz);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(QuestUpdateListener questUpdateListener) {
        try {
            QuestUpdateBinderCallback questUpdateBinderCallback = new QuestUpdateBinderCallback(questUpdateListener);
            ((IGamesService)this.ft()).d((IGamesCallbacks)questUpdateBinderCallback, this.Nz);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void hj() {
        try {
            ((IGamesService)this.ft()).u(this.Nz);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(OnRequestReceivedListener onRequestReceivedListener) {
        try {
            RequestReceivedBinderCallback requestReceivedBinderCallback = new RequestReceivedBinderCallback(onRequestReceivedListener);
            ((IGamesService)this.ft()).c((IGamesCallbacks)requestReceivedBinderCallback, this.Nz);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void hk() {
        try {
            ((IGamesService)this.ft()).t(this.Nz);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public Intent hl() {
        Intent intent;
        try {
            intent = ((IGamesService)this.ft()).hl();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent a(Room room, int n2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.ft()).a((RoomEntity)room.freeze(), n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent hm() {
        Intent intent;
        try {
            intent = ((IGamesService)this.ft()).hm();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void f(a.d<GamesMetadata.LoadGamesResult> d2) {
        try {
            ((IGamesService)this.ft()).d(new GamesLoadedBinderCallback(d2));
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Status> d2) {
        try {
            this.Np.flush();
            ((IGamesService)this.ft()).a(new SignOutCompleteBinderCallbacks(d2));
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public int hn() {
        int n2 = 4368;
        try {
            n2 = ((IGamesService)this.ft()).hn();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
        return n2;
    }

    public String ho() {
        try {
            return ((IGamesService)this.ft()).ho();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            return null;
        }
    }

    public void c(a.d<Invitations.LoadInvitationsResult> d2, int n2) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new InvitationsLoadedBinderCallback(d2), n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void m(String string2, int n2) {
        try {
            ((IGamesService)this.ft()).m(string2, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void n(String string2, int n2) {
        try {
            ((IGamesService)this.ft()).n(string2, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public Intent a(int n2, int n3, boolean bl2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.ft()).a(n2, n3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void a(a.d<TurnBasedMultiplayer.InitiateMatchResult> d2, TurnBasedMatchConfig turnBasedMatchConfig) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(d2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.iH(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void d(a.d<TurnBasedMultiplayer.InitiateMatchResult> d2, String string2) {
        try {
            ((IGamesService)this.ft()).l(new TurnBasedMatchInitiatedBinderCallbacks(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void e(a.d<TurnBasedMultiplayer.InitiateMatchResult> d2, String string2) {
        try {
            ((IGamesService)this.ft()).m(new TurnBasedMatchInitiatedBinderCallbacks(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public int hp() {
        int n2 = -1;
        try {
            n2 = ((IGamesService)this.ft()).hp();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
        return n2;
    }

    public void a(a.d<TurnBasedMultiplayer.UpdateMatchResult> d2, String string2, byte[] byArray, String string3, ParticipantResult[] participantResultArray) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(d2), string2, byArray, string3, participantResultArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<TurnBasedMultiplayer.UpdateMatchResult> d2, String string2, byte[] byArray, ParticipantResult[] participantResultArray) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(d2), string2, byArray, participantResultArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void f(a.d<TurnBasedMultiplayer.LeaveMatchResult> d2, String string2) {
        try {
            ((IGamesService)this.ft()).o(new TurnBasedMatchLeftBinderCallbacks(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<TurnBasedMultiplayer.LeaveMatchResult> d2, String string2, String string3) {
        try {
            ((IGamesService)this.ft()).c((IGamesCallbacks)new TurnBasedMatchLeftBinderCallbacks(d2), string2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void g(a.d<TurnBasedMultiplayer.CancelMatchResult> d2, String string2) {
        try {
            ((IGamesService)this.ft()).n(new TurnBasedMatchCanceledBinderCallbacks(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void aS(String string2) {
        try {
            ((IGamesService)this.ft()).ba(string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<TurnBasedMultiplayer.LoadMatchesResult> d2, int n2, int[] nArray) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(d2), n2, nArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void h(a.d<TurnBasedMultiplayer.LoadMatchResult> d2, String string2) {
        try {
            ((IGamesService)this.ft()).p(new TurnBasedMatchLoadedBinderCallbacks(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public Intent b(int n2, int n3, boolean bl2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.ft()).b(n2, n3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void a(RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(roomConfig.getRoomUpdateListener(), roomConfig.getRoomStatusUpdateListener(), roomConfig.getMessageReceivedListener());
            ((IGamesService)this.ft()).a((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.Ny, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), roomConfig.isSocketEnabled(), this.Nz);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void b(RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(roomConfig.getRoomUpdateListener(), roomConfig.getRoomStatusUpdateListener(), roomConfig.getMessageReceivedListener());
            ((IGamesService)this.ft()).a((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.Ny, roomConfig.getInvitationId(), roomConfig.isSocketEnabled(), this.Nz);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(RoomUpdateListener roomUpdateListener, String string2) {
        try {
            ((IGamesService)this.ft()).c((IGamesCallbacks)new RoomBinderCallbacks(roomUpdateListener), string2);
            this.hv();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public int a(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback, byte[] byArray, String string2, String string3) {
        try {
            return ((IGamesService)this.ft()).a((IGamesCallbacks)new RealTimeReliableMessageBinderCallbacks(reliableMessageSentCallback), byArray, string2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            return -1;
        }
    }

    public int a(byte[] byArray, String string2, String[] stringArray) {
        hm.b(stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((IGamesService)this.ft()).b(byArray, string2, stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            return -1;
        }
    }

    public int d(byte[] byArray, String string2) {
        try {
            return ((IGamesService)this.ft()).b(byArray, string2, null);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            return -1;
        }
    }

    public RealTimeSocket l(String string2, String string3) {
        if (string3 == null || !ParticipantUtils.bn(string3)) {
            throw new IllegalArgumentException("Bad participant ID");
        }
        RealTimeSocket realTimeSocket = this.Nr.get(string3);
        if (realTimeSocket == null || realTimeSocket.isClosed()) {
            return this.aT(string3);
        }
        return realTimeSocket;
    }

    private RealTimeSocket aT(String string2) {
        try {
            ParcelFileDescriptor parcelFileDescriptor = ((IGamesService)this.ft()).bb(string2);
            if (parcelFileDescriptor != null) {
                GamesLog.i("GamesClientImpl", "Created native libjingle socket.");
                LibjingleNativeSocket libjingleNativeSocket = new LibjingleNativeSocket(parcelFileDescriptor);
                this.Nr.put(string2, libjingleNativeSocket);
                return libjingleNativeSocket;
            }
            GamesLog.i("GamesClientImpl", "Unable to create native libjingle socket, resorting to old socket.");
            String string3 = ((IGamesService)this.ft()).aW(string2);
            if (string3 == null) {
                return null;
            }
            LocalSocket localSocket = new LocalSocket();
            try {
                localSocket.connect(new LocalSocketAddress(string3));
            }
            catch (IOException iOException) {
                GamesLog.k("GamesClientImpl", "connect() call failed on socket: " + iOException.getMessage());
                return null;
            }
            RealTimeSocketImpl realTimeSocketImpl = new RealTimeSocketImpl(localSocket, string2);
            this.Nr.put(string2, realTimeSocketImpl);
            return realTimeSocketImpl;
        }
        catch (RemoteException remoteException) {
            GamesLog.k("GamesClientImpl", "Unable to create socket. Service died.");
            return null;
        }
    }

    public void ch(int n2) {
        try {
            ((IGamesService)this.ft()).ch(n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public Intent hq() {
        Intent intent;
        try {
            intent = ((IGamesService)this.ft()).hq();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent a(int n2, byte[] byArray, int n3, Bitmap bitmap, String string2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.ft()).a(n2, byArray, n3, string2);
            hm.b(bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public int hr() {
        int n2 = -1;
        try {
            n2 = ((IGamesService)this.ft()).hr();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
        return n2;
    }

    public int hs() {
        int n2 = -1;
        try {
            n2 = ((IGamesService)this.ft()).hs();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
        return n2;
    }

    public void b(a.d<Requests.UpdateRequestsResult> d2, String[] stringArray) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(d2), stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void c(a.d<Requests.UpdateRequestsResult> d2, String[] stringArray) {
        try {
            ((IGamesService)this.ft()).b((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(d2), stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Requests.LoadRequestsResult> d2, int n2, int n3, int n4) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new RequestsLoadedBinderCallbacks(d2), n2, n3, n4);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public Intent a(int[] nArray) {
        Intent intent;
        try {
            intent = ((IGamesService)this.ft()).a(nArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent aU(String string2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.ft()).aU(string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void i(a.d<Quests.AcceptQuestResult> d2, String string2) {
        try {
            this.Np.flush();
            ((IGamesService)this.ft()).u(new QuestAcceptedBinderCallbacks(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Quests.ClaimMilestoneResult> d2, String string2, String string3) {
        try {
            this.Np.flush();
            ((IGamesService)this.ft()).f(new QuestMilestoneClaimBinderCallbacks(d2, string3), string2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Quests.LoadQuestsResult> d2, int[] nArray, int n2, boolean bl2) {
        try {
            this.Np.flush();
            ((IGamesService)this.ft()).a((IGamesCallbacks)new QuestsLoadedBinderCallbacks(d2), nArray, n2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Quests.LoadQuestsResult> d2, boolean bl2, String[] stringArray) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new QuestsLoadedBinderCallbacks(d2), stringArray, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Quests.LoadQuestsResult> d2, String string2, String string3, int[] nArray, int n2, boolean bl2) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new QuestsLoadedBinderCallbacks(d2), string2, string3, nArray, n2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Quests.LoadQuestsResult> d2, String string2, String string3, boolean bl2, String[] stringArray) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new QuestsLoadedBinderCallbacks(d2), string2, string3, stringArray, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public int ht() {
        int n2 = -1;
        try {
            n2 = ((IGamesService)this.ft()).ht();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
        return n2;
    }

    public int hu() {
        int n2 = -1;
        try {
            n2 = ((IGamesService)this.ft()).hu();
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
        return n2;
    }

    public Intent a(String string2, boolean bl2, boolean bl3, int n2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.ft()).a(string2, bl2, bl3, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void e(a.d<Snapshots.LoadSnapshotsResult> d2, boolean bl2) {
        try {
            ((IGamesService)this.ft()).d((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(d2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Snapshots.OpenSnapshotResult> d2, String string2, boolean bl2) {
        try {
            ((IGamesService)this.ft()).e((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(d2), string2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Snapshots.CommitSnapshotResult> d2, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) {
        Contents contents = snapshot.getContents();
        hm.b(contents, (Object)"Must provide a previously opened Snapshot");
        a a2 = snapshotMetadataChange.iN();
        if (a2 != null) {
            a2.a(this.getContext().getCacheDir());
        }
        snapshot.iM();
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new SnapshotCommittedBinderCallbacks(d2), snapshot.getMetadata().getSnapshotId(), snapshotMetadataChange, contents);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(Snapshot snapshot) {
        Contents contents = snapshot.getContents();
        hm.b(contents, (Object)"Must provide a previously opened Snapshot");
        snapshot.iM();
        try {
            ((IGamesService)this.ft()).a(contents);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void j(a.d<Snapshots.DeleteSnapshotResult> d2, String string2) {
        try {
            ((IGamesService)this.ft()).r(new SnapshotDeletedBinderCallbacks(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Snapshots.OpenSnapshotResult> d2, String string2, String string3, SnapshotMetadataChange snapshotMetadataChange, Contents contents) {
        a a2 = snapshotMetadataChange.iN();
        if (a2 != null) {
            a2.a(this.getContext().getCacheDir());
        }
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(d2), string2, string3, snapshotMetadataChange, contents);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<GamesMetadata.LoadExtendedGamesResult> d2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(d2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void k(a.d<GamesMetadata.LoadExtendedGamesResult> d2, String string2) {
        try {
            ((IGamesService)this.ft()).e((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void l(a.d<GamesMetadata.LoadGameInstancesResult> d2, String string2) {
        try {
            ((IGamesService)this.ft()).f((IGamesCallbacks)new GameInstancesLoadedBinderCallback(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<GamesMetadata.LoadExtendedGamesResult> d2, int n2, int n3, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(d2), n2, n3, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<GamesMetadata.LoadExtendedGamesResult> d2, String string2, int n2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(d2), string2, n2, bl2, bl3, bl4, bl5);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void c(a.d<GamesMetadata.LoadExtendedGamesResult> d2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.ft()).e(new ExtendedGamesLoadedBinderCallback(d2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void d(a.d<GamesMetadata.LoadExtendedGamesResult> d2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.ft()).f(new ExtendedGamesLoadedBinderCallback(d2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void e(a.d<GamesMetadata.LoadExtendedGamesResult> d2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.ft()).c(new ExtendedGamesLoadedBinderCallback(d2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void m(a.d<GamesMetadata.LoadGameSearchSuggestionsResult> d2, String string2) {
        try {
            ((IGamesService)this.ft()).q(new GameSearchSuggestionsLoadedBinderCallback(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void c(a.d<Leaderboards.LeaderboardMetadataResult> d2, String string2, boolean bl2) {
        try {
            ((IGamesService)this.ft()).d((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(d2), string2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Leaderboards.LeaderboardMetadataResult> d2, String string2, String string3, boolean bl2) {
        try {
            ((IGamesService)this.ft()).b((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(d2), string2, string3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Leaderboards.LoadScoresResult> d2, String string2, String string3, int n2, int n3, int n4, boolean bl2) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(d2), string2, string3, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Leaderboards.LoadScoresResult> d2, String string2, String string3, int n2, int n3, int n4, boolean bl2) {
        try {
            ((IGamesService)this.ft()).b(new LeaderboardScoresLoadedBinderCallback(d2), string2, string3, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Players.LoadPlayersResult> d2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.ft()).b((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void c(a.d<Players.LoadPlayersResult> d2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.ft()).c((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void d(a.d<Players.LoadPlayersResult> d2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.ft()).e(new PlayersLoadedBinderCallback(d2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Players.LoadPlayersResult> d2, String string2, int n2, boolean bl2) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), string2, n2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void f(a.d<Players.LoadPlayersResult> d2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.ft()).b((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void e(a.d<Players.LoadPlayersResult> d2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.ft()).d(new PlayersLoadedBinderCallback(d2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void g(a.d<Players.LoadPlayersResult> d2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.ft()).b((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), string2, null, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void g(a.d<Players.LoadOwnerCoverPhotoUrisResult> d2) {
        try {
            ((IGamesService)this.ft()).j(new OwnerCoverPhotoUrisLoadedBinderCallback(d2));
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void n(a.d<Players.LoadXpForGameCategoriesResult> d2, String string2) {
        try {
            ((IGamesService)this.ft()).s(new PlayerXpForGameCategoriesLoadedBinderCallback(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void c(a.d<Players.LoadXpStreamResult> d2, String string2, int n2) {
        try {
            ((IGamesService)this.ft()).b((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(d2), string2, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void d(a.d<Players.LoadXpStreamResult> d2, String string2, int n2) {
        try {
            ((IGamesService)this.ft()).c((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(d2), string2, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Achievements.LoadAchievementsResult> d2, String string2, String string3, boolean bl2) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new AchievementsLoadedBinderCallback(d2), string2, string3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void c(a.d<TurnBasedMultiplayer.InitiateMatchResult> d2, String string2, String string3) {
        try {
            ((IGamesService)this.ft()).d((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(d2), string2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void d(a.d<TurnBasedMultiplayer.InitiateMatchResult> d2, String string2, String string3) {
        try {
            ((IGamesService)this.ft()).e((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(d2), string2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void e(a.d<Invitations.LoadInvitationsResult> d2, String string2, int n2) {
        try {
            ((IGamesService)this.ft()).b((IGamesCallbacks)new InvitationsLoadedBinderCallback(d2), string2, n2, false);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void o(a.d<Invitations.LoadInvitationsResult> d2, String string2) {
        try {
            ((IGamesService)this.ft()).k(new InvitationsLoadedBinderCallback(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<TurnBasedMultiplayer.LoadMatchesResult> d2, String string2, int n2, int[] nArray) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(d2), string2, n2, nArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void h(a.d<Acls.LoadAclResult> d2) {
        try {
            ((IGamesService)this.ft()).h(new NotifyAclLoadedBinderCallback(d2));
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void p(a.d<Status> d2, String string2) {
        try {
            ((IGamesService)this.ft()).j(new NotifyAclUpdatedBinderCallback(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void d(a.d<Notifications.GameMuteStatusChangeResult> d2, String string2, boolean bl2) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new GameMuteStatusChangedBinderCallback(d2), string2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void q(a.d<Notifications.GameMuteStatusLoadResult> d2, String string2) {
        try {
            ((IGamesService)this.ft()).i(new GameMuteStatusLoadedBinderCallback(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    @Deprecated
    public void i(a.d<Notifications.ContactSettingLoadResult> d2) {
        try {
            ((IGamesService)this.ft()).e((IGamesCallbacks)new ContactSettingsLoadedBinderCallback(d2), false);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void f(a.d<Notifications.ContactSettingLoadResult> d2, boolean bl2) {
        try {
            ((IGamesService)this.ft()).e((IGamesCallbacks)new ContactSettingsLoadedBinderCallback(d2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Status> d2, boolean bl2, Bundle bundle) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new ContactSettingsUpdatedBinderCallback(d2), bl2, bundle);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void j(a.d<Notifications.InboxCountResult> d2) {
        try {
            ((IGamesService)this.ft()).t(new InboxCountsLoadedBinderCallback(d2), null);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Requests.SendRequestResult> d2, String string2, String[] stringArray, int n2, byte[] byArray, int n3) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new RequestSentBinderCallbacks(d2), string2, stringArray, n2, byArray, n3);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Requests.UpdateRequestsResult> d2, String string2, String string3, String[] stringArray) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(d2), string2, string3, stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Requests.LoadRequestsResult> d2, String string2, String string3, int n2, int n3, int n4) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new RequestsLoadedBinderCallbacks(d2), string2, string3, n2, n3, n4);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void f(a.d<Requests.LoadRequestSummariesResult> d2, String string2, int n2) {
        try {
            ((IGamesService)this.ft()).a((IGamesCallbacks)new RequestSummariesLoadedBinderCallbacks(d2), string2, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    public void c(a.d<Snapshots.LoadSnapshotsResult> d2, String string2, String string3, boolean bl2) {
        try {
            ((IGamesService)this.ft()).c((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(d2), string2, string3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.j("GamesClientImpl", "service died");
        }
    }

    private void hv() {
        for (RealTimeSocket realTimeSocket : this.Nr.values()) {
            try {
                realTimeSocket.close();
            }
            catch (IOException iOException) {
                GamesLog.b("GamesClientImpl", "IOException:", iOException);
            }
        }
        this.Nr.clear();
    }

    public void a(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.ft()).a(iBinder, bundle);
            }
            catch (RemoteException remoteException) {
                GamesLog.j("GamesClientImpl", "service died");
            }
        }
    }

    public void hw() {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.ft()).hw();
            }
            catch (RemoteException remoteException) {
                GamesLog.j("GamesClientImpl", "service died");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Room Q(DataHolder dataHolder) {
        Room room = null;
        try (RoomBuffer roomBuffer = new RoomBuffer(dataHolder);){
            if (roomBuffer.getCount() > 0) {
                room = (Room)((Room)roomBuffer.get(0)).freeze();
            }
        }
        return room;
    }

    @Override
    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        if (n2 == 0 && bundle != null) {
            this.Nv = bundle.getBoolean("show_welcome_popup");
        }
        super.a(n2, iBinder, bundle);
    }

    @Override
    protected /* synthetic */ IInterface x(IBinder iBinder) {
        return this.ah(iBinder);
    }

    private static final class DeleteSnapshotResultImpl
    implements Snapshots.DeleteSnapshotResult {
        private final Status yz;
        private final String NK;

        DeleteSnapshotResultImpl(int statusCode, String snapshotId) {
            this.yz = new Status(statusCode);
            this.NK = snapshotId;
        }

        @Override
        public Status getStatus() {
            return this.yz;
        }

        @Override
        public String getSnapshotId() {
            return this.NK;
        }
    }

    private static final class CommitSnapshotResultImpl
    extends b
    implements Snapshots.CommitSnapshotResult {
        private final SnapshotMetadata NJ;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CommitSnapshotResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try (SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);){
                this.NJ = snapshotMetadataBuffer.getCount() > 0 ? new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0)) : null;
            }
        }

        @Override
        public SnapshotMetadata getSnapshotMetadata() {
            return this.NJ;
        }
    }

    private static final class OpenSnapshotResultImpl
    extends b
    implements Snapshots.OpenSnapshotResult {
        private final Snapshot Om;
        private final String On;
        private final Snapshot Oo;
        private final Contents Op;

        OpenSnapshotResultImpl(DataHolder dataHolder, Contents currentContents) {
            this(dataHolder, null, currentContents, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OpenSnapshotResultImpl(DataHolder metadataHolder, String conflictId, Contents currentContents, Contents conflictContents, Contents resolutionContents) {
            super(metadataHolder);
            try (SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(metadataHolder);){
                if (snapshotMetadataBuffer.getCount() == 0) {
                    this.Om = null;
                    this.Oo = null;
                } else if (snapshotMetadataBuffer.getCount() == 1) {
                    gx.A(metadataHolder.getStatusCode() != 4004);
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0));
                    this.Om = new SnapshotEntity(snapshotMetadataEntity, currentContents);
                    this.Oo = null;
                } else {
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0));
                    this.Om = new SnapshotEntity(snapshotMetadataEntity, currentContents);
                    SnapshotMetadataEntity snapshotMetadataEntity2 = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(1));
                    this.Oo = new SnapshotEntity(snapshotMetadataEntity2, conflictContents);
                }
            }
            this.On = conflictId;
            this.Op = resolutionContents;
        }

        @Override
        public Snapshot getSnapshot() {
            return this.Om;
        }

        @Override
        public String getConflictId() {
            return this.On;
        }

        @Override
        public Snapshot getConflictingSnapshot() {
            return this.Oo;
        }

        @Override
        public Contents getResolutionContents() {
            return this.Op;
        }
    }

    private static final class LoadSnapshotsResultImpl
    extends b
    implements Snapshots.LoadSnapshotsResult {
        LoadSnapshotsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public SnapshotMetadataBuffer getSnapshots() {
            return new SnapshotMetadataBuffer(this.DG);
        }
    }

    private static final class LoadQuestsResultImpl
    extends b
    implements Quests.LoadQuestsResult {
        private final DataHolder DG;

        LoadQuestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.DG = dataHolder;
        }

        @Override
        public QuestBuffer getQuests() {
            return new QuestBuffer(this.DG);
        }
    }

    private static final class ClaimMilestoneResultImpl
    extends b
    implements Quests.ClaimMilestoneResult {
        private final Milestone NI;
        private final Quest NG;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClaimMilestoneResultImpl(DataHolder dataHolder, String milestoneId) {
            super(dataHolder);
            try (QuestBuffer questBuffer = new QuestBuffer(dataHolder);){
                if (questBuffer.getCount() > 0) {
                    this.NG = new QuestEntity((Quest)questBuffer.get(0));
                    List<Milestone> list = this.NG.iJ();
                    int n2 = list.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        if (!list.get(i2).getMilestoneId().equals(milestoneId)) continue;
                        this.NI = list.get(i2);
                        return;
                    }
                    this.NI = null;
                } else {
                    this.NI = null;
                    this.NG = null;
                }
            }
        }

        @Override
        public Milestone getMilestone() {
            return this.NI;
        }

        @Override
        public Quest getQuest() {
            return this.NG;
        }
    }

    private static final class AcceptQuestResultImpl
    extends b
    implements Quests.AcceptQuestResult {
        private final Quest NG;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AcceptQuestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try (QuestBuffer questBuffer = new QuestBuffer(dataHolder);){
                this.NG = questBuffer.getCount() > 0 ? new QuestEntity((Quest)questBuffer.get(0)) : null;
            }
        }

        @Override
        public Quest getQuest() {
            return this.NG;
        }
    }

    private static final class LoadRequestSummariesResultImpl
    extends b
    implements Requests.LoadRequestSummariesResult {
        LoadRequestSummariesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadRequestsResultImpl
    implements Requests.LoadRequestsResult {
        private final Status yz;
        private final Bundle Oc;

        LoadRequestsResultImpl(Status status, Bundle requestData) {
            this.yz = status;
            this.Oc = requestData;
        }

        @Override
        public Status getStatus() {
            return this.yz;
        }

        @Override
        public GameRequestBuffer getRequests(int requestType) {
            String string2 = RequestType.cm(requestType);
            if (!this.Oc.containsKey(string2)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.Oc.get(string2);
            return new GameRequestBuffer(dataHolder);
        }

        @Override
        public void release() {
            for (String string2 : this.Oc.keySet()) {
                DataHolder dataHolder = (DataHolder)this.Oc.getParcelable(string2);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }
    }

    private static final class UpdateRequestsResultImpl
    extends b
    implements Requests.UpdateRequestsResult {
        private final RequestUpdateOutcomes OU;

        UpdateRequestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.OU = RequestUpdateOutcomes.U(dataHolder);
        }

        @Override
        public int getRequestOutcome(String requestId) {
            return this.OU.getRequestOutcome(requestId);
        }

        @Override
        public Set<String> getRequestIds() {
            return this.OU.getRequestIds();
        }
    }

    private static final class SendRequestResultImpl
    extends b
    implements Requests.SendRequestResult {
        private final GameRequest OA;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SendRequestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try (GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);){
                this.OA = gameRequestBuffer.getCount() > 0 ? (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze() : null;
            }
        }
    }

    private static final class InboxCountResultImpl
    implements Notifications.InboxCountResult {
        private final Status yz;
        private final Bundle NN;

        InboxCountResultImpl(Status status, Bundle inboxCounts) {
            this.yz = status;
            this.NN = inboxCounts;
        }

        @Override
        public Status getStatus() {
            return this.yz;
        }
    }

    private static final class ContactSettingLoadResultImpl
    extends b
    implements Notifications.ContactSettingLoadResult {
        ContactSettingLoadResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class GameMuteStatusLoadResultImpl
    implements Notifications.GameMuteStatusLoadResult {
        private final Status yz;
        private final String NL;
        private final boolean NM;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GameMuteStatusLoadResultImpl(DataHolder dataHolder) {
            try {
                this.yz = new Status(dataHolder.getStatusCode());
                if (dataHolder.getCount() > 0) {
                    this.NL = dataHolder.c("external_game_id", 0, 0);
                    this.NM = dataHolder.d("muted", 0, 0);
                } else {
                    this.NL = null;
                    this.NM = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public Status getStatus() {
            return this.yz;
        }
    }

    private static final class GameMuteStatusChangeResultImpl
    implements Notifications.GameMuteStatusChangeResult {
        private final Status yz;
        private final String NL;
        private final boolean NM;

        public GameMuteStatusChangeResultImpl(int statusCode, String externalGameId, boolean isMuted) {
            this.yz = new Status(statusCode);
            this.NL = externalGameId;
            this.NM = isMuted;
        }

        @Override
        public Status getStatus() {
            return this.yz;
        }
    }

    private static final class LoadAclResultImpl
    extends b
    implements Acls.LoadAclResult {
        LoadAclResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class CancelMatchResultImpl
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status yz;
        private final String NH;

        CancelMatchResultImpl(Status status, String externalMatchId) {
            this.yz = status;
            this.NH = externalMatchId;
        }

        @Override
        public Status getStatus() {
            return this.yz;
        }

        @Override
        public String getMatchId() {
            return this.NH;
        }
    }

    private static final class LeaveMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LeaveMatchResult {
        LeaveMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class UpdateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.UpdateMatchResult {
        UpdateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class InitiateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.InitiateMatchResult {
        InitiateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LoadMatchResult {
        LoadMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static abstract class TurnBasedMatchResult
    extends b {
        final TurnBasedMatch Ok;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TurnBasedMatchResult(DataHolder dataHolder) {
            super(dataHolder);
            try (TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);){
                this.Ok = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
            }
        }

        public TurnBasedMatch getMatch() {
            return this.Ok;
        }
    }

    private static final class SubmitScoreResultImpl
    extends b
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData OM;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SubmitScoreResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try {
                this.OM = new ScoreSubmissionData(dataHolder);
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public ScoreSubmissionData getScoreData() {
            return this.OM;
        }
    }

    private static final class LoadOwnerCoverPhotoUrisResultImpl
    implements Players.LoadOwnerCoverPhotoUrisResult {
        private final Status yz;
        private final Bundle HM;

        LoadOwnerCoverPhotoUrisResultImpl(int statusCode, Bundle bundle) {
            this.yz = new Status(statusCode);
            this.HM = bundle;
        }

        @Override
        public Status getStatus() {
            return this.yz;
        }
    }

    private static final class LoadXpStreamResultImpl
    extends b
    implements Players.LoadXpStreamResult {
        private final ExperienceEventBuffer Oh;

        LoadXpStreamResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Oh = new ExperienceEventBuffer(dataHolder);
        }
    }

    private static final class LoadXpForGameCategoriesResultImpl
    implements Players.LoadXpForGameCategoriesResult {
        private final Status yz;
        private final List<String> Of;
        private final Bundle Og;

        LoadXpForGameCategoriesResultImpl(Status status, Bundle xpData) {
            this.yz = status;
            this.Of = xpData.getStringArrayList("game_category_list");
            this.Og = xpData;
        }

        @Override
        public Status getStatus() {
            return this.yz;
        }
    }

    private static final class LoadPlayersResultImpl
    extends b
    implements Players.LoadPlayersResult {
        private final PlayerBuffer Ob;

        LoadPlayersResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.Ob = new PlayerBuffer(dataHolder);
        }

        @Override
        public PlayerBuffer getPlayers() {
            return this.Ob;
        }
    }

    private static final class LoadMatchesResultImpl
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status yz;
        private final LoadMatchesResponse NZ;

        LoadMatchesResultImpl(Status status, Bundle matchData) {
            this.yz = status;
            this.NZ = new LoadMatchesResponse(matchData);
        }

        @Override
        public Status getStatus() {
            return this.yz;
        }

        @Override
        public LoadMatchesResponse getMatches() {
            return this.NZ;
        }

        @Override
        public void release() {
            this.NZ.close();
        }
    }

    private static final class LoadInvitationsResultImpl
    extends b
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer NY;

        LoadInvitationsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.NY = new InvitationBuffer(dataHolder);
        }

        @Override
        public InvitationBuffer getInvitations() {
            return this.NY;
        }
    }

    private static final class LoadPlayerScoreResultImpl
    extends b
    implements Leaderboards.LoadPlayerScoreResult {
        private final LeaderboardScoreEntity Oa;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadPlayerScoreResultImpl(DataHolder scoreHolder) {
            super(scoreHolder);
            try (LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(scoreHolder);){
                this.Oa = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)leaderboardScoreBuffer.get(0).freeze() : null;
            }
        }

        @Override
        public LeaderboardScore getScore() {
            return this.Oa;
        }
    }

    private static final class LoadScoresResultImpl
    extends b
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity Od;
        private final LeaderboardScoreBuffer Oe;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadScoresResultImpl(DataHolder leaderboard, DataHolder scores) {
            super(scores);
            try (LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(leaderboard);){
                this.Od = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            this.Oe = new LeaderboardScoreBuffer(scores);
        }

        @Override
        public Leaderboard getLeaderboard() {
            return this.Od;
        }

        @Override
        public LeaderboardScoreBuffer getScores() {
            return this.Oe;
        }
    }

    private static final class LeaderboardMetadataResultImpl
    extends b
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer NR;

        LeaderboardMetadataResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.NR = new LeaderboardBuffer(dataHolder);
        }

        @Override
        public LeaderboardBuffer getLeaderboards() {
            return this.NR;
        }
    }

    private static final class LoadGameSearchSuggestionsResultImpl
    extends b
    implements GamesMetadata.LoadGameSearchSuggestionsResult {
        LoadGameSearchSuggestionsResultImpl(DataHolder data) {
            super(data);
        }
    }

    private static final class LoadGameInstancesResultImpl
    extends b
    implements GamesMetadata.LoadGameInstancesResult {
        private final GameInstanceBuffer NW;

        LoadGameInstancesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.NW = new GameInstanceBuffer(dataHolder);
        }
    }

    private static final class LoadExtendedGamesResultImpl
    extends b
    implements GamesMetadata.LoadExtendedGamesResult {
        private final ExtendedGameBuffer NV;

        LoadExtendedGamesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.NV = new ExtendedGameBuffer(dataHolder);
        }
    }

    private static final class LoadGamesResultImpl
    extends b
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer NX;

        LoadGamesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.NX = new GameBuffer(dataHolder);
        }

        @Override
        public GameBuffer getGames() {
            return this.NX;
        }
    }

    private static final class LoadEventResultImpl
    extends b
    implements Events.LoadEventsResult {
        private final EventBuffer NU;

        LoadEventResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.NU = new EventBuffer(dataHolder);
        }

        @Override
        public EventBuffer getEvents() {
            return this.NU;
        }
    }

    private static final class UpdateAchievementResultImpl
    implements Achievements.UpdateAchievementResult {
        private final Status yz;
        private final String OT;

        UpdateAchievementResultImpl(int statusCode, String achievementId) {
            this.yz = new Status(statusCode);
            this.OT = achievementId;
        }

        @Override
        public Status getStatus() {
            return this.yz;
        }

        @Override
        public String getAchievementId() {
            return this.OT;
        }
    }

    private static final class LoadAchievementsResultImpl
    extends b
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer NT;

        LoadAchievementsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.NT = new AchievementBuffer(dataHolder);
        }

        @Override
        public AchievementBuffer getAchievements() {
            return this.NT;
        }
    }

    private final class RealTimeMessageSentCallback
    extends hb.b<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int CT;
        private final String Ow;
        private final int Ox;

        RealTimeMessageSentCallback(RealTimeMultiplayer.ReliableMessageSentCallback listener, int statusCode, int token, String recipientParticipantId) {
            super(GamesClientImpl.this, listener);
            this.CT = statusCode;
            this.Ox = token;
            this.Ow = recipientParticipantId;
        }

        public void a(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback) {
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(this.CT, this.Ox, this.Ow);
            }
        }

        @Override
        protected void fu() {
        }

        @Override
        public /* synthetic */ void d(Object object) {
            this.a((RealTimeMultiplayer.ReliableMessageSentCallback)object);
        }
    }

    private final class MessageReceivedCallback
    extends hb.b<RealTimeMessageReceivedListener> {
        private final RealTimeMessage Ol;

        MessageReceivedCallback(RealTimeMessageReceivedListener listener, RealTimeMessage message) {
            super(GamesClientImpl.this, listener);
            this.Ol = message;
        }

        public void a(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            if (realTimeMessageReceivedListener != null) {
                realTimeMessageReceivedListener.onRealTimeMessageReceived(this.Ol);
            }
        }

        @Override
        protected void fu() {
        }

        @Override
        public /* synthetic */ void d(Object object) {
            this.a((RealTimeMessageReceivedListener)object);
        }
    }

    private final class P2PDisconnectedCallback
    extends hb.b<RoomStatusUpdateListener> {
        private final String Oq;

        P2PDisconnectedCallback(RoomStatusUpdateListener listener, String participantId) {
            super(GamesClientImpl.this, listener);
            this.Oq = participantId;
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onP2PDisconnected(this.Oq);
            }
        }

        @Override
        protected void fu() {
        }

        @Override
        public /* synthetic */ void d(Object object) {
            this.a((RoomStatusUpdateListener)object);
        }
    }

    private final class P2PConnectedCallback
    extends hb.b<RoomStatusUpdateListener> {
        private final String Oq;

        P2PConnectedCallback(RoomStatusUpdateListener listener, String participantId) {
            super(GamesClientImpl.this, listener);
            this.Oq = participantId;
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onP2PConnected(this.Oq);
            }
        }

        @Override
        protected void fu() {
        }

        @Override
        public /* synthetic */ void d(Object object) {
            this.a((RoomStatusUpdateListener)object);
        }
    }

    private final class PeerDisconnectedCallback
    extends AbstractPeerStatusCallback {
        PeerDisconnectedCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    private final class PeerConnectedCallback
    extends AbstractPeerStatusCallback {
        PeerConnectedCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    private final class PeerDeclinedCallback
    extends AbstractPeerStatusCallback {
        PeerDeclinedCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    private final class PeerLeftRoomCallback
    extends AbstractPeerStatusCallback {
        PeerLeftRoomCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    private final class PeerJoinedRoomCallback
    extends AbstractPeerStatusCallback {
        PeerJoinedRoomCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    private final class PeerInvitedToRoomCallback
    extends AbstractPeerStatusCallback {
        PeerInvitedToRoomCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    private final class DisconnectedFromRoomCallback
    extends AbstractRoomStatusCallback {
        DisconnectedFromRoomCallback(RoomStatusUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    private final class ConnectedToRoomCallback
    extends AbstractRoomStatusCallback {
        ConnectedToRoomCallback(RoomStatusUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    private final class RoomAutoMatchingCallback
    extends AbstractRoomStatusCallback {
        RoomAutoMatchingCallback(RoomStatusUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    private final class RoomConnectingCallback
    extends AbstractRoomStatusCallback {
        RoomConnectingCallback(RoomStatusUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    private final class RoomConnectedCallback
    extends AbstractRoomCallback {
        RoomConnectedCallback(RoomUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onRoomConnected(n2, room);
        }
    }

    private final class LeftRoomCallback
    extends hb.b<RoomUpdateListener> {
        private final int CT;
        private final String NS;

        LeftRoomCallback(RoomUpdateListener listener, int statusCode, String roomId) {
            super(GamesClientImpl.this, listener);
            this.CT = statusCode;
            this.NS = roomId;
        }

        public void a(RoomUpdateListener roomUpdateListener) {
            roomUpdateListener.onLeftRoom(this.CT, this.NS);
        }

        @Override
        protected void fu() {
        }

        @Override
        public /* synthetic */ void d(Object object) {
            this.a((RoomUpdateListener)object);
        }
    }

    private final class JoinedRoomCallback
    extends AbstractRoomCallback {
        public JoinedRoomCallback(RoomUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onJoinedRoom(n2, room);
        }
    }

    private final class RoomCreatedCallback
    extends AbstractRoomCallback {
        public RoomCreatedCallback(RoomUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onRoomCreated(n2, room);
        }
    }

    private abstract class AbstractPeerStatusCallback
    extends AbstractRoomStatusCallback {
        private final ArrayList<String> NF;

        AbstractPeerStatusCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder);
            this.NF = new ArrayList();
            int n2 = participantIds.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.NF.add(participantIds[i2]);
            }
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.a(roomStatusUpdateListener, room, this.NF);
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    private abstract class AbstractRoomStatusCallback
    extends hb.d<RoomStatusUpdateListener> {
        AbstractRoomStatusCallback(RoomStatusUpdateListener listener, DataHolder dataHolder) {
            super(GamesClientImpl.this, listener, dataHolder);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            this.a(roomStatusUpdateListener, GamesClientImpl.this.Q(dataHolder));
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2);
    }

    private abstract class AbstractRoomCallback
    extends hb.d<RoomUpdateListener> {
        AbstractRoomCallback(RoomUpdateListener listener, DataHolder dataHolder) {
            super(GamesClientImpl.this, listener, dataHolder);
        }

        @Override
        protected void a(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            this.a(roomUpdateListener, GamesClientImpl.this.Q(dataHolder), dataHolder.getStatusCode());
        }

        protected abstract void a(RoomUpdateListener var1, Room var2, int var3);
    }

    private final class RequestRemovedCallback
    extends hb.b<OnRequestReceivedListener> {
        private final String OB;

        RequestRemovedCallback(OnRequestReceivedListener listener, String requestId) {
            super(GamesClientImpl.this, listener);
            this.OB = requestId;
        }

        protected void b(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestRemoved(this.OB);
        }

        @Override
        protected void fu() {
        }

        @Override
        protected /* synthetic */ void d(Object object) {
            this.b((OnRequestReceivedListener)object);
        }
    }

    private final class RequestReceivedCallback
    extends hb.b<OnRequestReceivedListener> {
        private final GameRequest OA;

        RequestReceivedCallback(OnRequestReceivedListener listener, GameRequest request) {
            super(GamesClientImpl.this, listener);
            this.OA = request;
        }

        protected void b(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestReceived(this.OA);
        }

        @Override
        protected void fu() {
        }

        @Override
        protected /* synthetic */ void d(Object object) {
            this.b((OnRequestReceivedListener)object);
        }
    }

    private final class QuestCompletedCallback
    extends hb.b<QuestUpdateListener> {
        private final Quest NG;

        QuestCompletedCallback(QuestUpdateListener listener, Quest quest) {
            super(GamesClientImpl.this, listener);
            this.NG = quest;
        }

        protected void b(QuestUpdateListener questUpdateListener) {
            questUpdateListener.onQuestCompleted(this.NG);
        }

        @Override
        protected void fu() {
        }

        @Override
        protected /* synthetic */ void d(Object object) {
            this.b((QuestUpdateListener)object);
        }
    }

    private final class MatchRemovedCallback
    extends hb.b<OnTurnBasedMatchUpdateReceivedListener> {
        private final String Oi;

        MatchRemovedCallback(OnTurnBasedMatchUpdateReceivedListener listener, String matchId) {
            super(GamesClientImpl.this, listener);
            this.Oi = matchId;
        }

        protected void b(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(this.Oi);
        }

        @Override
        protected void fu() {
        }

        @Override
        protected /* synthetic */ void d(Object object) {
            this.b((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private final class MatchUpdateReceivedCallback
    extends hb.b<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch Ok;

        MatchUpdateReceivedCallback(OnTurnBasedMatchUpdateReceivedListener listener, TurnBasedMatch match) {
            super(GamesClientImpl.this, listener);
            this.Ok = match;
        }

        protected void b(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(this.Ok);
        }

        @Override
        protected void fu() {
        }

        @Override
        protected /* synthetic */ void d(Object object) {
            this.b((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private final class InvitationRemovedCallback
    extends hb.b<OnInvitationReceivedListener> {
        private final String NQ;

        InvitationRemovedCallback(OnInvitationReceivedListener listener, String invitationId) {
            super(GamesClientImpl.this, listener);
            this.NQ = invitationId;
        }

        protected void b(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationRemoved(this.NQ);
        }

        @Override
        protected void fu() {
        }

        @Override
        protected /* synthetic */ void d(Object object) {
            this.b((OnInvitationReceivedListener)object);
        }
    }

    private final class InvitationReceivedCallback
    extends hb.b<OnInvitationReceivedListener> {
        private final Invitation NP;

        InvitationReceivedCallback(OnInvitationReceivedListener listener, Invitation invitation) {
            super(GamesClientImpl.this, listener);
            this.NP = invitation;
        }

        protected void b(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationReceived(this.NP);
        }

        @Override
        protected void fu() {
        }

        @Override
        protected /* synthetic */ void d(Object object) {
            this.b((OnInvitationReceivedListener)object);
        }
    }

    final class SnapshotDeletedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Snapshots.DeleteSnapshotResult> yR;

        public SnapshotDeletedBinderCallbacks(a.d<Snapshots.DeleteSnapshotResult> resultHolder) {
            this.yR = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void g(int n2, String string2) {
            this.yR.a(new DeleteSnapshotResultImpl(n2, string2));
        }
    }

    private final class SnapshotCommittedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Snapshots.CommitSnapshotResult> OJ;

        public SnapshotCommittedBinderCallbacks(a.d<Snapshots.CommitSnapshotResult> resultHolder) {
            this.OJ = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void J(DataHolder dataHolder) {
            this.OJ.a(new CommitSnapshotResultImpl(dataHolder));
        }
    }

    private final class SnapshotOpenedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Snapshots.OpenSnapshotResult> OK;

        public SnapshotOpenedBinderCallbacks(a.d<Snapshots.OpenSnapshotResult> resultHolder) {
            this.OK = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void a(DataHolder dataHolder, Contents contents) {
            this.OK.a(new OpenSnapshotResultImpl(dataHolder, contents));
        }

        @Override
        public void a(DataHolder dataHolder, String string2, Contents contents, Contents contents2, Contents contents3) {
            this.OK.a(new OpenSnapshotResultImpl(dataHolder, string2, contents, contents2, contents3));
        }
    }

    private final class SnapshotsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Snapshots.LoadSnapshotsResult> OL;

        public SnapshotsLoadedBinderCallbacks(a.d<Snapshots.LoadSnapshotsResult> resultHolder) {
            this.OL = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void I(DataHolder dataHolder) {
            this.OL.a(new LoadSnapshotsResultImpl(dataHolder));
        }
    }

    private final class QuestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Quests.LoadQuestsResult> Ov;

        public QuestsLoadedBinderCallbacks(a.d<Quests.LoadQuestsResult> resultHolder) {
            this.Ov = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void O(DataHolder dataHolder) {
            this.Ov.a(new LoadQuestsResultImpl(dataHolder));
        }
    }

    private final class QuestMilestoneClaimBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Quests.ClaimMilestoneResult> Os;
        private final String Ot;

        public QuestMilestoneClaimBinderCallbacks(a.d<Quests.ClaimMilestoneResult> resultHolder, String milestoneId) {
            this.Os = hm.b(resultHolder, (Object)"Holder must not be null");
            this.Ot = hm.b(milestoneId, (Object)"MilestoneId must not be null");
        }

        @Override
        public void K(DataHolder dataHolder) {
            this.Os.a(new ClaimMilestoneResultImpl(dataHolder, this.Ot));
        }
    }

    private final class QuestAcceptedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Quests.AcceptQuestResult> Or;

        public QuestAcceptedBinderCallbacks(a.d<Quests.AcceptQuestResult> resultHolder) {
            this.Or = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void L(DataHolder dataHolder) {
            this.Or.a(new AcceptQuestResultImpl(dataHolder));
        }
    }

    private final class RequestSummariesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Requests.LoadRequestSummariesResult> OD;

        public RequestSummariesLoadedBinderCallbacks(a.d<Requests.LoadRequestSummariesResult> resultHolder) {
            this.OD = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void H(DataHolder dataHolder) {
            this.OD.a(new LoadRequestSummariesResultImpl(dataHolder));
        }
    }

    private final class RequestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Requests.LoadRequestsResult> OE;

        public RequestsLoadedBinderCallbacks(a.d<Requests.LoadRequestsResult> resultHolder) {
            this.OE = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void c(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            this.OE.a(new LoadRequestsResultImpl(status, bundle));
        }
    }

    private final class RequestSentBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Requests.SendRequestResult> OC;

        public RequestSentBinderCallbacks(a.d<Requests.SendRequestResult> resultHolder) {
            this.OC = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void G(DataHolder dataHolder) {
            this.OC.a(new SendRequestResultImpl(dataHolder));
        }
    }

    private final class RequestsUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Requests.UpdateRequestsResult> OF;

        public RequestsUpdatedBinderCallbacks(a.d<Requests.UpdateRequestsResult> resultHolder) {
            this.OF = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void F(DataHolder dataHolder) {
            this.OF.a(new UpdateRequestsResultImpl(dataHolder));
        }
    }

    private final class SignOutCompleteBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Status> yR;

        public SignOutCompleteBinderCallbacks(a.d<Status> resultHolder) {
            this.yR = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void dT() {
            Status status = new Status(0);
            this.yR.a(status);
        }
    }

    private final class InboxCountsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Notifications.InboxCountResult> yR;

        InboxCountsLoadedBinderCallback(a.d<Notifications.InboxCountResult> holder) {
            this.yR = hm.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void f(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            this.yR.a(new InboxCountResultImpl(status, bundle));
        }
    }

    private final class ContactSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Status> yR;

        ContactSettingsUpdatedBinderCallback(a.d<Status> holder) {
            this.yR = hm.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void ce(int n2) {
            this.yR.a(new Status(n2));
        }
    }

    private final class ContactSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Notifications.ContactSettingLoadResult> yR;

        ContactSettingsLoadedBinderCallback(a.d<Notifications.ContactSettingLoadResult> holder) {
            this.yR = hm.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void D(DataHolder dataHolder) {
            this.yR.a(new ContactSettingLoadResultImpl(dataHolder));
        }
    }

    private final class GameMuteStatusLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Notifications.GameMuteStatusLoadResult> yR;

        GameMuteStatusLoadedBinderCallback(a.d<Notifications.GameMuteStatusLoadResult> holder) {
            this.yR = hm.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void B(DataHolder dataHolder) {
            this.yR.a(new GameMuteStatusLoadResultImpl(dataHolder));
        }
    }

    private final class GameMuteStatusChangedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Notifications.GameMuteStatusChangeResult> yR;

        GameMuteStatusChangedBinderCallback(a.d<Notifications.GameMuteStatusChangeResult> holder) {
            this.yR = hm.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void a(int n2, String string2, boolean bl2) {
            this.yR.a(new GameMuteStatusChangeResultImpl(n2, string2, bl2));
        }
    }

    private final class NotifyAclUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Status> yR;

        NotifyAclUpdatedBinderCallback(a.d<Status> resultHolder) {
            this.yR = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void cd(int n2) {
            this.yR.a(new Status(n2));
        }
    }

    private final class NotifyAclLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Acls.LoadAclResult> yR;

        NotifyAclLoadedBinderCallback(a.d<Acls.LoadAclResult> resultHolder) {
            this.yR = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void C(DataHolder dataHolder) {
            this.yR.a(new LoadAclResultImpl(dataHolder));
        }
    }

    private final class RealTimeReliableMessageBinderCallbacks
    extends AbstractGamesCallbacks {
        final RealTimeMultiplayer.ReliableMessageSentCallback Oy;

        public RealTimeReliableMessageBinderCallbacks(RealTimeMultiplayer.ReliableMessageSentCallback messageSentCallbacks) {
            this.Oy = messageSentCallbacks;
        }

        @Override
        public void b(int n2, int n3, String string2) {
            GamesClientImpl.this.a(new RealTimeMessageSentCallback(this.Oy, n2, n3, string2));
        }
    }

    private final class RoomBinderCallbacks
    extends AbstractGamesCallbacks {
        private final RoomUpdateListener OG;
        private final RoomStatusUpdateListener OH;
        private final RealTimeMessageReceivedListener OI;

        public RoomBinderCallbacks(RoomUpdateListener roomCallbacks) {
            this.OG = hm.b(roomCallbacks, (Object)"Callbacks must not be null");
            this.OH = null;
            this.OI = null;
        }

        public RoomBinderCallbacks(RoomUpdateListener roomCallbacks, RoomStatusUpdateListener roomStatusCallbacks, RealTimeMessageReceivedListener realTimeMessageReceivedCallbacks) {
            this.OG = hm.b(roomCallbacks, (Object)"Callbacks must not be null");
            this.OH = roomStatusCallbacks;
            this.OI = realTimeMessageReceivedCallbacks;
        }

        @Override
        public void u(DataHolder dataHolder) {
            GamesClientImpl.this.a(new RoomCreatedCallback(this.OG, dataHolder));
        }

        @Override
        public void v(DataHolder dataHolder) {
            GamesClientImpl.this.a(new JoinedRoomCallback(this.OG, dataHolder));
        }

        @Override
        public void onLeftRoom(int statusCode, String externalRoomId) {
            GamesClientImpl.this.a(new LeftRoomCallback(this.OG, statusCode, externalRoomId));
        }

        @Override
        public void y(DataHolder dataHolder) {
            GamesClientImpl.this.a(new RoomConnectedCallback(this.OG, dataHolder));
        }

        @Override
        public void w(DataHolder dataHolder) {
            GamesClientImpl.this.a(new RoomConnectingCallback(this.OH, dataHolder));
        }

        @Override
        public void x(DataHolder dataHolder) {
            GamesClientImpl.this.a(new RoomAutoMatchingCallback(this.OH, dataHolder));
        }

        @Override
        public void z(DataHolder dataHolder) {
            GamesClientImpl.this.a(new ConnectedToRoomCallback(this.OH, dataHolder));
        }

        @Override
        public void A(DataHolder dataHolder) {
            GamesClientImpl.this.a(new DisconnectedFromRoomCallback(this.OH, dataHolder));
        }

        @Override
        public void e(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerConnectedCallback(this.OH, dataHolder, stringArray));
        }

        @Override
        public void f(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerDisconnectedCallback(this.OH, dataHolder, stringArray));
        }

        @Override
        public void a(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerInvitedToRoomCallback(this.OH, dataHolder, stringArray));
        }

        @Override
        public void b(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerJoinedRoomCallback(this.OH, dataHolder, stringArray));
        }

        @Override
        public void c(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerLeftRoomCallback(this.OH, dataHolder, stringArray));
        }

        @Override
        public void d(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerDeclinedCallback(this.OH, dataHolder, stringArray));
        }

        @Override
        public void onP2PConnected(String participantId) {
            GamesClientImpl.this.a(new P2PConnectedCallback(this.OH, participantId));
        }

        @Override
        public void onP2PDisconnected(String participantId) {
            GamesClientImpl.this.a(new P2PDisconnectedCallback(this.OH, participantId));
        }

        @Override
        public void onRealTimeMessageReceived(RealTimeMessage message) {
            GamesClientImpl.this.a(new MessageReceivedCallback(this.OI, message));
        }
    }

    private final class TurnBasedMatchCanceledBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<TurnBasedMultiplayer.CancelMatchResult> ON;

        public TurnBasedMatchCanceledBinderCallbacks(a.d<TurnBasedMultiplayer.CancelMatchResult> resultHolder) {
            this.ON = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void f(int n2, String string2) {
            Status status = new Status(n2);
            this.ON.a(new CancelMatchResultImpl(status, string2));
        }
    }

    private final class TurnBasedMatchLeftBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<TurnBasedMultiplayer.LeaveMatchResult> OP;

        public TurnBasedMatchLeftBinderCallbacks(a.d<TurnBasedMultiplayer.LeaveMatchResult> resultHolder) {
            this.OP = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void s(DataHolder dataHolder) {
            this.OP.a(new LeaveMatchResultImpl(dataHolder));
        }
    }

    private final class TurnBasedMatchUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<TurnBasedMultiplayer.UpdateMatchResult> OR;

        public TurnBasedMatchUpdatedBinderCallbacks(a.d<TurnBasedMultiplayer.UpdateMatchResult> resultHolder) {
            this.OR = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void r(DataHolder dataHolder) {
            this.OR.a(new UpdateMatchResultImpl(dataHolder));
        }
    }

    private final class TurnBasedMatchInitiatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<TurnBasedMultiplayer.InitiateMatchResult> OO;

        public TurnBasedMatchInitiatedBinderCallbacks(a.d<TurnBasedMultiplayer.InitiateMatchResult> resultHolder) {
            this.OO = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void q(DataHolder dataHolder) {
            this.OO.a(new InitiateMatchResultImpl(dataHolder));
        }
    }

    private final class TurnBasedMatchLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<TurnBasedMultiplayer.LoadMatchResult> OQ;

        public TurnBasedMatchLoadedBinderCallbacks(a.d<TurnBasedMultiplayer.LoadMatchResult> resultHolder) {
            this.OQ = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void p(DataHolder dataHolder) {
            this.OQ.a(new LoadMatchResultImpl(dataHolder));
        }
    }

    private final class TurnBasedMatchesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<TurnBasedMultiplayer.LoadMatchesResult> OS;

        public TurnBasedMatchesLoadedBinderCallbacks(a.d<TurnBasedMultiplayer.LoadMatchesResult> resultHolder) {
            this.OS = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void b(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            this.OS.a(new LoadMatchesResultImpl(status, bundle));
        }
    }

    private final class SubmitScoreBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Leaderboards.SubmitScoreResult> yR;

        public SubmitScoreBinderCallbacks(a.d<Leaderboards.SubmitScoreResult> resultHolder) {
            this.yR = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void f(DataHolder dataHolder) {
            this.yR.a(new SubmitScoreResultImpl(dataHolder));
        }
    }

    private final class OwnerCoverPhotoUrisLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Players.LoadOwnerCoverPhotoUrisResult> yR;

        OwnerCoverPhotoUrisLoadedBinderCallback(a.d<Players.LoadOwnerCoverPhotoUrisResult> holder) {
            this.yR = hm.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void d(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            this.yR.a(new LoadOwnerCoverPhotoUrisResultImpl(n2, bundle));
        }
    }

    final class PlayerXpStreamLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Players.LoadXpStreamResult> yR;

        PlayerXpStreamLoadedBinderCallback(a.d<Players.LoadXpStreamResult> holder) {
            this.yR = hm.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void P(DataHolder dataHolder) {
            this.yR.a(new LoadXpStreamResultImpl(dataHolder));
        }
    }

    private final class PlayerXpForGameCategoriesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Players.LoadXpForGameCategoriesResult> yR;

        PlayerXpForGameCategoriesLoadedBinderCallback(a.d<Players.LoadXpForGameCategoriesResult> holder) {
            this.yR = hm.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void e(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            this.yR.a(new LoadXpForGameCategoriesResultImpl(status, bundle));
        }
    }

    private final class PlayersLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Players.LoadPlayersResult> yR;

        PlayersLoadedBinderCallback(a.d<Players.LoadPlayersResult> holder) {
            this.yR = hm.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void g(DataHolder dataHolder) {
            this.yR.a(new LoadPlayersResultImpl(dataHolder));
        }

        @Override
        public void h(DataHolder dataHolder) {
            this.yR.a(new LoadPlayersResultImpl(dataHolder));
        }
    }

    private final class RequestReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final OnRequestReceivedListener Oz;

        RequestReceivedBinderCallback(OnRequestReceivedListener listener) {
            this.Oz = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void o(DataHolder dataHolder) {
            GameRequest gameRequest = null;
            try (GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);){
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            if (gameRequest != null) {
                GamesClientImpl.this.a(new RequestReceivedCallback(this.Oz, gameRequest));
            }
        }

        @Override
        public void onRequestRemoved(String requestId) {
            GamesClientImpl.this.a(new RequestRemovedCallback(this.Oz, requestId));
        }
    }

    private final class QuestUpdateBinderCallback
    extends AbstractGamesCallbacks {
        private final QuestUpdateListener Ou;

        QuestUpdateBinderCallback(QuestUpdateListener listener) {
            this.Ou = listener;
        }

        @Override
        public void M(DataHolder dataHolder) {
            Quest quest = this.R(dataHolder);
            if (quest != null) {
                GamesClientImpl.this.a(new QuestCompletedCallback(this.Ou, quest));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Quest R(DataHolder dataHolder) {
            Quest quest = null;
            try (QuestBuffer questBuffer = new QuestBuffer(dataHolder);){
                if (questBuffer.getCount() > 0) {
                    quest = (Quest)((Quest)questBuffer.get(0)).freeze();
                }
            }
            return quest;
        }
    }

    private final class MatchUpdateReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final OnTurnBasedMatchUpdateReceivedListener Oj;

        MatchUpdateReceivedBinderCallback(OnTurnBasedMatchUpdateReceivedListener listener) {
            this.Oj = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void t(DataHolder dataHolder) {
            TurnBasedMatch turnBasedMatch = null;
            try (TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);){
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            if (turnBasedMatch != null) {
                GamesClientImpl.this.a(new MatchUpdateReceivedCallback(this.Oj, turnBasedMatch));
            }
        }

        @Override
        public void onTurnBasedMatchRemoved(String matchId) {
            GamesClientImpl.this.a(new MatchRemovedCallback(this.Oj, matchId));
        }
    }

    private final class InvitationReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final OnInvitationReceivedListener NO;

        InvitationReceivedBinderCallback(OnInvitationReceivedListener listener) {
            this.NO = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void n(DataHolder dataHolder) {
            Invitation invitation = null;
            try (InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);){
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            if (invitation != null) {
                GamesClientImpl.this.a(new InvitationReceivedCallback(this.NO, invitation));
            }
        }

        @Override
        public void onInvitationRemoved(String invitationId) {
            GamesClientImpl.this.a(new InvitationRemovedCallback(this.NO, invitationId));
        }
    }

    private final class InvitationsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Invitations.LoadInvitationsResult> yR;

        InvitationsLoadedBinderCallback(a.d<Invitations.LoadInvitationsResult> resultHolder) {
            this.yR = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void m(DataHolder dataHolder) {
            this.yR.a(new LoadInvitationsResultImpl(dataHolder));
        }
    }

    private final class PlayerLeaderboardScoreLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Leaderboards.LoadPlayerScoreResult> yR;

        PlayerLeaderboardScoreLoadedBinderCallback(a.d<Leaderboards.LoadPlayerScoreResult> resultHolder) {
            this.yR = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void E(DataHolder dataHolder) {
            this.yR.a(new LoadPlayerScoreResultImpl(dataHolder));
        }
    }

    private final class LeaderboardScoresLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Leaderboards.LoadScoresResult> yR;

        LeaderboardScoresLoadedBinderCallback(a.d<Leaderboards.LoadScoresResult> resultHolder) {
            this.yR = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void a(DataHolder dataHolder, DataHolder dataHolder2) {
            this.yR.a(new LoadScoresResultImpl(dataHolder, dataHolder2));
        }
    }

    private final class LeaderboardsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Leaderboards.LeaderboardMetadataResult> yR;

        LeaderboardsLoadedBinderCallback(a.d<Leaderboards.LeaderboardMetadataResult> resultHolder) {
            this.yR = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void e(DataHolder dataHolder) {
            this.yR.a(new LeaderboardMetadataResultImpl(dataHolder));
        }
    }

    private final class GameSearchSuggestionsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<GamesMetadata.LoadGameSearchSuggestionsResult> yR;

        GameSearchSuggestionsLoadedBinderCallback(a.d<GamesMetadata.LoadGameSearchSuggestionsResult> holder) {
            this.yR = hm.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void l(DataHolder dataHolder) {
            this.yR.a(new LoadGameSearchSuggestionsResultImpl(dataHolder));
        }
    }

    private final class GameInstancesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<GamesMetadata.LoadGameInstancesResult> yR;

        GameInstancesLoadedBinderCallback(a.d<GamesMetadata.LoadGameInstancesResult> holder) {
            this.yR = hm.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void k(DataHolder dataHolder) {
            this.yR.a(new LoadGameInstancesResultImpl(dataHolder));
        }
    }

    private final class ExtendedGamesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<GamesMetadata.LoadExtendedGamesResult> yR;

        ExtendedGamesLoadedBinderCallback(a.d<GamesMetadata.LoadExtendedGamesResult> holder) {
            this.yR = hm.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void j(DataHolder dataHolder) {
            this.yR.a(new LoadExtendedGamesResultImpl(dataHolder));
        }
    }

    private final class EventsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Events.LoadEventsResult> yR;

        EventsLoadedBinderCallback(a.d<Events.LoadEventsResult> resultHolder) {
            this.yR = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void d(DataHolder dataHolder) {
            this.yR.a(new LoadEventResultImpl(dataHolder));
        }
    }

    private final class GamesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<GamesMetadata.LoadGamesResult> yR;

        GamesLoadedBinderCallback(a.d<GamesMetadata.LoadGamesResult> holder) {
            this.yR = hm.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void i(DataHolder dataHolder) {
            this.yR.a(new LoadGamesResultImpl(dataHolder));
        }
    }

    private final class AchievementUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Achievements.UpdateAchievementResult> yR;

        AchievementUpdatedBinderCallback(a.d<Achievements.UpdateAchievementResult> resultHolder) {
            this.yR = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void e(int n2, String string2) {
            this.yR.a(new UpdateAchievementResultImpl(n2, string2));
        }
    }

    private final class AchievementsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Achievements.LoadAchievementsResult> yR;

        AchievementsLoadedBinderCallback(a.d<Achievements.LoadAchievementsResult> resultHolder) {
            this.yR = hm.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void c(DataHolder dataHolder) {
            this.yR.a(new LoadAchievementsResultImpl(dataHolder));
        }
    }

    private class GameClientEventIncrementCache
    extends EventIncrementCache {
        public GameClientEventIncrementCache() {
            super(GamesClientImpl.this.getContext().getMainLooper(), 1000);
        }

        @Override
        protected void o(String string2, int n2) {
            try {
                ((IGamesService)GamesClientImpl.this.ft()).l(string2, n2);
            }
            catch (RemoteException remoteException) {
                GamesLog.j("GamesClientImpl", "service died");
            }
        }
    }
}

