/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationEntityCreator;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.internal.hk;
import com.google.android.gms.internal.hm;
import java.util.ArrayList;

public final class InvitationEntity
extends GamesDowngradeableSafeParcel
implements Invitation {
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new InvitationEntityCreatorCompat();
    private final int xM;
    private final GameEntity Rt;
    private final String NQ;
    private final long SU;
    private final int SV;
    private final ParticipantEntity SW;
    private final ArrayList<ParticipantEntity> SX;
    private final int SY;
    private final int SZ;

    InvitationEntity(Invitation invitation) {
        this.xM = 2;
        this.Rt = new GameEntity(invitation.getGame());
        this.NQ = invitation.getInvitationId();
        this.SU = invitation.getCreationTimestamp();
        this.SV = invitation.getInvitationType();
        this.SY = invitation.getVariant();
        this.SZ = invitation.getAvailableAutoMatchSlots();
        String string2 = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n2 = arrayList.size();
        this.SX = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant2 = (Participant)arrayList.get(i2);
            if (participant2.getParticipantId().equals(string2)) {
                participant = participant2;
            }
            this.SX.add((ParticipantEntity)participant2.freeze());
        }
        hm.b(participant, (Object)"Must have a valid inviter!");
        this.SW = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(int versionCode, GameEntity game, String invitationId, long creationTimestamp, int invitationType, ParticipantEntity inviter, ArrayList<ParticipantEntity> participants, int variant, int availableAutoMatchSlots) {
        this.xM = versionCode;
        this.Rt = game;
        this.NQ = invitationId;
        this.SU = creationTimestamp;
        this.SV = invitationType;
        this.SW = inviter;
        this.SX = participants;
        this.SY = variant;
        this.SZ = availableAutoMatchSlots;
    }

    public int getVersionCode() {
        return this.xM;
    }

    @Override
    public Game getGame() {
        return this.Rt;
    }

    @Override
    public String getInvitationId() {
        return this.NQ;
    }

    @Override
    public Participant getInviter() {
        return this.SW;
    }

    @Override
    public long getCreationTimestamp() {
        return this.SU;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.SX);
    }

    @Override
    public int getInvitationType() {
        return this.SV;
    }

    @Override
    public int getVariant() {
        return this.SY;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        return this.SZ;
    }

    @Override
    public Invitation freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return InvitationEntity.a(this);
    }

    static int a(Invitation invitation) {
        return hk.hashCode(invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.getInvitationType(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant(), invitation.getAvailableAutoMatchSlots());
    }

    public boolean equals(Object obj) {
        return InvitationEntity.a(this, obj);
    }

    static boolean a(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return hk.equal(invitation2.getGame(), invitation.getGame()) && hk.equal(invitation2.getInvitationId(), invitation.getInvitationId()) && hk.equal(invitation2.getCreationTimestamp(), invitation.getCreationTimestamp()) && hk.equal(invitation2.getInvitationType(), invitation.getInvitationType()) && hk.equal(invitation2.getInviter(), invitation.getInviter()) && hk.equal(invitation2.getParticipants(), invitation.getParticipants()) && hk.equal(invitation2.getVariant(), invitation.getVariant()) && hk.equal(invitation2.getAvailableAutoMatchSlots(), invitation.getAvailableAutoMatchSlots());
    }

    public String toString() {
        return InvitationEntity.b(this);
    }

    static String b(Invitation invitation) {
        return hk.e(invitation).a("Game", invitation.getGame()).a("InvitationId", invitation.getInvitationId()).a("CreationTimestamp", invitation.getCreationTimestamp()).a("InvitationType", invitation.getInvitationType()).a("Inviter", invitation.getInviter()).a("Participants", invitation.getParticipants()).a("Variant", invitation.getVariant()).a("AvailableAutoMatchSlots", invitation.getAvailableAutoMatchSlots()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.fr()) {
            InvitationEntityCreator.a(this, dest, flags);
        } else {
            this.Rt.writeToParcel(dest, flags);
            dest.writeString(this.NQ);
            dest.writeLong(this.SU);
            dest.writeInt(this.SV);
            this.SW.writeToParcel(dest, flags);
            int n2 = this.SX.size();
            dest.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.SX.get(i2).writeToParcel(dest, flags);
            }
        }
    }

    static final class InvitationEntityCreatorCompat
    extends InvitationEntityCreator {
        InvitationEntityCreatorCompat() {
        }

        @Override
        public InvitationEntity bl(Parcel parcel) {
            int n2;
            boolean bl2 = InvitationEntity.c(InvitationEntity.fq());
            if (bl2 || InvitationEntity.aA(InvitationEntity.class.getCanonicalName())) {
                return super.bl(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string2 = parcel.readString();
            long l2 = parcel.readLong();
            int n3 = parcel.readInt();
            ParticipantEntity participantEntity = (ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n4 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n4);
            for (n2 = 0; n2 < n4; ++n2) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n2 = -1;
            int n5 = 0;
            return new InvitationEntity(2, gameEntity, string2, l2, n3, participantEntity, arrayList, n2, n5);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.bl(x0);
        }
    }
}

