/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestEntityCreator;
import com.google.android.gms.internal.hk;
import com.google.android.gms.internal.ik;
import java.util.ArrayList;
import java.util.List;

public final class QuestEntity
implements SafeParcelable,
Quest {
    public static final QuestEntityCreator CREATOR = new QuestEntityCreator();
    private final int xM;
    private final GameEntity Rt;
    private final String TP;
    private final long TQ;
    private final Uri TR;
    private final String TS;
    private final String Mp;
    private final long TT;
    private final long TB;
    private final Uri TU;
    private final String TV;
    private final String mName;
    private final long TW;
    private final long TX;
    private final int mState;
    private final int AT;
    private final ArrayList<MilestoneEntity> TY;

    public QuestEntity(Quest quest) {
        this.xM = 2;
        this.Rt = new GameEntity(quest.getGame());
        this.TP = quest.getQuestId();
        this.TQ = quest.getAcceptedTimestamp();
        this.Mp = quest.getDescription();
        this.TR = quest.getBannerImageUri();
        this.TS = quest.getBannerImageUrl();
        this.TT = quest.getEndTimestamp();
        this.TU = quest.getIconImageUri();
        this.TV = quest.getIconImageUrl();
        this.TB = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.TW = quest.iK();
        this.TX = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.AT = quest.getType();
        List<Milestone> list = quest.iJ();
        int n2 = list.size();
        this.TY = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.TY.add((MilestoneEntity)list.get(i2).freeze());
        }
    }

    QuestEntity(int versionCode, GameEntity game, String questId, long acceptedTimestamp, Uri bannerImageUri, String bannerImageUrl, String description, long endTimestamp, long lastUpdatedTimestamp, Uri iconImageUri, String iconImageUrl, String name, long notifyTimestamp, long startTimestamp, int state, int type, ArrayList<MilestoneEntity> milestones) {
        this.xM = versionCode;
        this.Rt = game;
        this.TP = questId;
        this.TQ = acceptedTimestamp;
        this.TR = bannerImageUri;
        this.TS = bannerImageUrl;
        this.Mp = description;
        this.TT = endTimestamp;
        this.TB = lastUpdatedTimestamp;
        this.TU = iconImageUri;
        this.TV = iconImageUrl;
        this.mName = name;
        this.TW = notifyTimestamp;
        this.TX = startTimestamp;
        this.mState = state;
        this.AT = type;
        this.TY = milestones;
    }

    public int getVersionCode() {
        return this.xM;
    }

    @Override
    public String getQuestId() {
        return this.TP;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        ik.b(this.mName, dataOut);
    }

    @Override
    public String getDescription() {
        return this.Mp;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        ik.b(this.Mp, dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.TU;
    }

    @Override
    public String getIconImageUrl() {
        return this.TV;
    }

    @Override
    public Uri getBannerImageUri() {
        return this.TR;
    }

    @Override
    public String getBannerImageUrl() {
        return this.TS;
    }

    @Override
    public Milestone getCurrentMilestone() {
        return this.iJ().get(0);
    }

    @Override
    public List<Milestone> iJ() {
        return new ArrayList<Milestone>(this.TY);
    }

    @Override
    public Game getGame() {
        return this.Rt;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getType() {
        return this.AT;
    }

    @Override
    public long getAcceptedTimestamp() {
        return this.TQ;
    }

    @Override
    public long getEndTimestamp() {
        return this.TT;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.TB;
    }

    @Override
    public long iK() {
        return this.TW;
    }

    @Override
    public long getStartTimestamp() {
        return this.TX;
    }

    @Override
    public boolean isEndingSoon() {
        return this.TW <= System.currentTimeMillis() + 1800000L;
    }

    @Override
    public Quest freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return QuestEntity.a(this);
    }

    static int a(Quest quest) {
        return hk.hashCode(quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.iJ(), quest.getName(), quest.iK(), quest.getStartTimestamp(), quest.getState());
    }

    public boolean equals(Object obj) {
        return QuestEntity.a(this, obj);
    }

    static boolean a(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return hk.equal(quest2.getGame(), quest.getGame()) && hk.equal(quest2.getQuestId(), quest.getQuestId()) && hk.equal(quest2.getAcceptedTimestamp(), quest.getAcceptedTimestamp()) && hk.equal(quest2.getBannerImageUri(), quest.getBannerImageUri()) && hk.equal(quest2.getDescription(), quest.getDescription()) && hk.equal(quest2.getEndTimestamp(), quest.getEndTimestamp()) && hk.equal(quest2.getIconImageUri(), quest.getIconImageUri()) && hk.equal(quest2.getLastUpdatedTimestamp(), quest.getLastUpdatedTimestamp()) && hk.equal(quest2.iJ(), quest.iJ()) && hk.equal(quest2.getName(), quest.getName()) && hk.equal(quest2.iK(), quest.iK()) && hk.equal(quest2.getStartTimestamp(), quest.getStartTimestamp()) && hk.equal(quest2.getState(), quest.getState());
    }

    public String toString() {
        return QuestEntity.b(this);
    }

    static String b(Quest quest) {
        return hk.e(quest).a("Game", quest.getGame()).a("QuestId", quest.getQuestId()).a("AcceptedTimestamp", quest.getAcceptedTimestamp()).a("BannerImageUri", quest.getBannerImageUri()).a("BannerImageUrl", quest.getBannerImageUrl()).a("Description", quest.getDescription()).a("EndTimestamp", quest.getEndTimestamp()).a("IconImageUri", quest.getIconImageUri()).a("IconImageUrl", quest.getIconImageUrl()).a("LastUpdatedTimestamp", quest.getLastUpdatedTimestamp()).a("Milestones", quest.iJ()).a("Name", quest.getName()).a("NotifyTimestamp", quest.iK()).a("StartTimestamp", quest.getStartTimestamp()).a("State", quest.getState()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        QuestEntityCreator.a(this, out, flags);
    }
}

