/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.internal.eo;
import com.google.android.gms.internal.et;
import java.util.Locale;

public final class ec {
    public final int rb;
    public final boolean rc;
    public final boolean rd;
    public final String re;
    public final String rf;
    public final boolean rg;
    public final boolean rh;
    public final boolean ri;
    public final String rj;
    public final String rk;
    public final int rl;
    public final int rm;
    public final int rn;
    public final int ro;
    public final int rp;
    public final int rq;
    public final float rr;
    public final int rs;
    public final int rt;
    public final double ru;
    public final boolean rv;
    public final boolean rw;
    public final int rx;

    public ec(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        Locale locale = Locale.getDefault();
        PackageManager packageManager = context.getPackageManager();
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = context.registerReceiver(null, intentFilter);
        this.rb = audioManager.getMode();
        this.rc = ec.a(packageManager, "geo:0,0?q=donuts") != null;
        this.rd = ec.a(packageManager, "http://www.google.com") != null;
        this.re = telephonyManager.getNetworkOperator();
        this.rf = locale.getCountry();
        this.rg = et.bV();
        this.rh = audioManager.isMusicActive();
        this.ri = audioManager.isSpeakerphoneOn();
        this.rj = locale.getLanguage();
        this.rk = ec.a(packageManager);
        this.rl = audioManager.getStreamVolume(3);
        this.rm = ec.a(context, connectivityManager, packageManager);
        this.rn = telephonyManager.getNetworkType();
        this.ro = telephonyManager.getPhoneType();
        this.rp = audioManager.getRingerMode();
        this.rq = audioManager.getStreamVolume(2);
        this.rr = displayMetrics.density;
        this.rs = displayMetrics.widthPixels;
        this.rt = displayMetrics.heightPixels;
        if (intent != null) {
            int n2 = intent.getIntExtra("status", -1);
            int n3 = intent.getIntExtra("level", -1);
            int n4 = intent.getIntExtra("scale", -1);
            this.ru = (float)n3 / (float)n4;
            this.rv = n2 == 2 || n2 == 5;
        } else {
            this.ru = -1.0;
            this.rv = false;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.rw = connectivityManager.isActiveNetworkMetered();
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            this.rx = networkInfo != null ? connectivityManager.getActiveNetworkInfo().getDetailedState().ordinal() : -1;
        } else {
            this.rw = false;
            this.rx = -1;
        }
    }

    private static String a(PackageManager packageManager) {
        ResolveInfo resolveInfo = ec.a(packageManager, "market://details?id=com.google.android.gms.ads");
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null) {
            return null;
        }
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(activityInfo.packageName, 0);
            return packageInfo != null ? packageInfo.versionCode + "." + activityInfo.packageName : null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static int a(Context context, ConnectivityManager connectivityManager, PackageManager packageManager) {
        int n2 = -2;
        if (eo.a(packageManager, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            n2 = networkInfo != null ? networkInfo.getType() : -1;
        }
        return n2;
    }

    private static ResolveInfo a(PackageManager packageManager, String string2) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
        return packageManager.resolveActivity(intent, 65536);
    }
}

