/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Rect;
import android.net.Uri;
import android.net.UrlQuerySanitizer;
import android.os.Build;
import android.os.Bundle;
import android.view.Window;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.google.android.gms.internal.eq;
import com.google.android.gms.internal.er;
import com.google.android.gms.internal.es;
import com.google.android.gms.internal.et;
import com.google.android.gms.internal.eu;
import java.io.IOException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.nio.CharBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class eo {
    private static final Object qp = new Object();
    private static boolean sl = true;
    private static String sm;
    private static boolean sn;

    public static void a(Context context, String string2, boolean bl2, HttpURLConnection httpURLConnection) {
        httpURLConnection.setConnectTimeout(60000);
        httpURLConnection.setInstanceFollowRedirects(bl2);
        httpURLConnection.setReadTimeout(60000);
        httpURLConnection.setRequestProperty("User-Agent", eo.c(context, string2));
        httpURLConnection.setUseCaches(false);
    }

    public static boolean m(Context context) {
        Intent intent = new Intent();
        intent.setClassName(context, "com.google.android.gms.ads.AdActivity");
        PackageManager packageManager = context.getPackageManager();
        ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
        boolean bl2 = true;
        if (resolveInfo == null || resolveInfo.activityInfo == null) {
            eu.D("Could not find com.google.android.gms.ads.AdActivity, please make sure it is declared in AndroidManifest.xml.");
            bl2 = false;
        } else {
            String string2 = "com.google.android.gms.ads.AdActivity requires the android:configChanges value to contain \"%s\".";
            if ((resolveInfo.activityInfo.configChanges & 0x10) == 0) {
                eu.D(String.format(string2, "keyboard"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x20) == 0) {
                eu.D(String.format(string2, "keyboardHidden"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x80) == 0) {
                eu.D(String.format(string2, "orientation"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x100) == 0) {
                eu.D(String.format(string2, "screenLayout"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x200) == 0) {
                eu.D(String.format(string2, "uiMode"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x400) == 0) {
                eu.D(String.format(string2, "screenSize"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x800) == 0) {
                eu.D(String.format(string2, "smallestScreenSize"));
                bl2 = false;
            }
        }
        return bl2;
    }

    public static boolean a(PackageManager packageManager, String string2, String string3) {
        return packageManager.checkPermission(string3, string2) == 0;
    }

    public static boolean bQ() {
        return sl;
    }

    public static int bR() {
        return Build.VERSION.SDK_INT >= 9 ? 6 : 0;
    }

    public static int bS() {
        return Build.VERSION.SDK_INT >= 9 ? 7 : 1;
    }

    public static void a(Context context, String string2, List<String> list) {
        for (String string3 : list) {
            new es(context, string2, string3).start();
        }
    }

    public static String a(Readable readable) throws IOException {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        CharBuffer charBuffer = CharBuffer.allocate(2048);
        while ((n2 = readable.read(charBuffer)) != -1) {
            charBuffer.flip();
            stringBuilder.append(charBuffer, 0, n2);
        }
        return stringBuilder.toString();
    }

    public static void n(Context context) {
        if (sn) {
            return;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        context.getApplicationContext().registerReceiver((BroadcastReceiver)new a(), intentFilter);
        sn = true;
    }

    public static void a(Context context, String string2, WebSettings webSettings) {
        webSettings.setUserAgentString(eo.c(context, string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String c(final Context context, String string2) {
        Object object = qp;
        synchronized (object) {
            if (sm != null) {
                return sm;
            }
            if (Build.VERSION.SDK_INT >= 17) {
                sm = er.getDefaultUserAgent(context);
            } else if (!et.bW()) {
                et.sv.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = qp;
                        synchronized (object) {
                            sm = eo.o(context);
                            qp.notifyAll();
                        }
                    }
                });
                while (sm == null) {
                    try {
                        qp.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        return sm;
                    }
                }
            } else {
                sm = eo.o(context);
            }
            sm = sm + " (Mobile; " + string2 + ")";
            return sm;
        }
    }

    private static String o(Context context) {
        return new WebView(context).getSettings().getUserAgentString();
    }

    public static boolean a(ClassLoader classLoader, Class<?> clazz, String string2) {
        try {
            Class<?> clazz2 = Class.forName(string2, false, classLoader);
            return clazz.isAssignableFrom(clazz2);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String v(String string2) {
        return Uri.parse((String)string2).buildUpon().query(null).build().toString();
    }

    public static JSONObject o(Map<String, ?> map) throws JSONException {
        try {
            JSONObject jSONObject = new JSONObject();
            for (String string2 : map.keySet()) {
                eo.a(jSONObject, string2, map.get(string2));
            }
            return jSONObject;
        }
        catch (ClassCastException classCastException) {
            throw new JSONException("Could not convert map to JSON: " + classCastException.getMessage());
        }
    }

    private static JSONObject b(Bundle bundle) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string2 : bundle.keySet()) {
            eo.a(jSONObject, string2, bundle.get(string2));
        }
        return jSONObject;
    }

    private static JSONArray a(Collection<?> collection) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object obj : collection) {
            eo.a(jSONArray, obj);
        }
        return jSONArray;
    }

    static JSONArray a(Object[] objectArray) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object object : objectArray) {
            eo.a(jSONArray, object);
        }
        return jSONArray;
    }

    private static void a(JSONArray jSONArray, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONArray.put((Object)eo.b((Bundle)object));
        } else if (object instanceof Map) {
            Map map = (Map)object;
            jSONArray.put((Object)eo.o(map));
        } else if (object instanceof Collection) {
            jSONArray.put((Object)eo.a((Collection)object));
        } else if (object instanceof Object[]) {
            jSONArray.put((Object)eo.a((Object[])object));
        } else {
            jSONArray.put(object);
        }
    }

    private static void a(JSONObject jSONObject, String string2, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONObject.put(string2, (Object)eo.b((Bundle)object));
        } else if (object instanceof Map) {
            Map map = (Map)object;
            jSONObject.put(string2, (Object)eo.o(map));
        } else if (object instanceof Collection) {
            jSONObject.put(string2 != null ? string2 : "null", (Object)eo.a((Collection)object));
        } else if (object instanceof Object[]) {
            jSONObject.put(string2, (Object)eo.a(Arrays.asList((Object[])object)));
        } else {
            jSONObject.put(string2, object);
        }
    }

    public static Map<String, String> c(Uri uri) {
        if (uri == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        UrlQuerySanitizer urlQuerySanitizer = new UrlQuerySanitizer();
        urlQuerySanitizer.setAllowUnregisteredParamaters(true);
        urlQuerySanitizer.setUnregisteredParameterValueSanitizer(UrlQuerySanitizer.getAllButNulLegal());
        urlQuerySanitizer.parseUrl(uri.toString());
        List list = urlQuerySanitizer.getParameterList();
        for (UrlQuerySanitizer.ParameterValuePair parameterValuePair : list) {
            hashMap.put(parameterValuePair.mParameter, parameterValuePair.mValue);
        }
        return hashMap;
    }

    public static void a(WebView webView) {
        if (Build.VERSION.SDK_INT >= 11) {
            eq.a(webView);
        }
    }

    public static void b(WebView webView) {
        if (Build.VERSION.SDK_INT >= 11) {
            eq.b(webView);
        }
    }

    public static String bT() {
        UUID uUID = UUID.randomUUID();
        byte[] byArray = BigInteger.valueOf(uUID.getLeastSignificantBits()).toByteArray();
        byte[] byArray2 = BigInteger.valueOf(uUID.getMostSignificantBits()).toByteArray();
        String string2 = new BigInteger(1, byArray).toString();
        for (int i2 = 0; i2 < 2; ++i2) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(byArray);
                messageDigest.update(byArray2);
                byte[] byArray3 = new byte[8];
                System.arraycopy(messageDigest.digest(), 0, byArray3, 0, 8);
                string2 = new BigInteger(1, byArray3).toString();
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return string2;
    }

    public static int p(Context context) {
        int n2 = 0;
        int n3 = 0;
        if (context instanceof Activity) {
            Activity activity = (Activity)context;
            Window window = activity.getWindow();
            Rect rect = new Rect();
            window.getDecorView().getWindowVisibleDisplayFrame(rect);
            n2 = rect.top;
            int n4 = window.findViewById(0x1020002).getTop();
            n3 = n4 - n2;
        }
        return n3 + n2;
    }

    static {
        sn = false;
    }

    private static final class a
    extends BroadcastReceiver {
        private a() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_PRESENT".equals(intent.getAction())) {
                sl = true;
            } else if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                sl = false;
            }
        }
    }
}

