/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.hk;
import com.google.android.gms.wearable.a;

public class Asset
implements SafeParcelable {
    public static final Parcelable.Creator<Asset> CREATOR = new a();
    final int xM;
    private byte[] TF;
    private String alg;
    public ParcelFileDescriptor alh;
    public Uri uri;

    Asset(int versionCode, byte[] data, String digest, ParcelFileDescriptor fd2, Uri uri) {
        this.xM = versionCode;
        this.TF = data;
        this.alg = digest;
        this.alh = fd2;
        this.uri = uri;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        a.a(this, dest, flags | 1);
    }

    public static Asset createFromRef(String digest) {
        if (digest == null) {
            throw new IllegalArgumentException("Asset digest cannot be null");
        }
        return new Asset(1, null, digest, null, null);
    }

    public static Asset createFromBytes(byte[] assetData) {
        if (assetData == null) {
            throw new IllegalArgumentException("Asset data cannot be null");
        }
        return new Asset(1, assetData, null, null, null);
    }

    public static Asset createFromFd(ParcelFileDescriptor fd2) {
        if (fd2 == null) {
            throw new IllegalArgumentException("Asset fd cannot be null");
        }
        return new Asset(1, null, null, fd2, null);
    }

    public static Asset createFromUri(Uri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Asset uri cannot be null");
        }
        return new Asset(1, null, null, null, uri);
    }

    public byte[] getData() {
        return this.TF;
    }

    public String getDigest() {
        return this.alg;
    }

    public ParcelFileDescriptor getFd() {
        return this.alh;
    }

    public Uri getUri() {
        return this.uri;
    }

    public int hashCode() {
        return hk.hashCode(this.TF, this.alg, this.alh, this.uri);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof Asset)) {
            return false;
        }
        Asset asset = (Asset)o2;
        return hk.equal(this.TF, asset.TF) && hk.equal(this.alg, asset.alg) && hk.equal(this.alh, asset.alh) && hk.equal(this.uri, asset.uri);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Asset[@");
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        if (this.alg == null) {
            stringBuilder.append(", nodigest");
        } else {
            stringBuilder.append(", ");
            stringBuilder.append(this.alg);
        }
        if (this.TF != null) {
            stringBuilder.append(", size=");
            stringBuilder.append(this.TF.length);
        }
        if (this.alh != null) {
            stringBuilder.append(", fd=");
            stringBuilder.append(this.alh);
        }
        if (this.uri != null) {
            stringBuilder.append(", uri=");
            stringBuilder.append(this.uri);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

